/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.rest;

import com.alibaba.fastjson.JSON;
import com.codingapi.springboot.framework.rest.RestTemplateContext;
import com.codingapi.springboot.framework.rest.properties.RestApiProperties;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

class HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    private final RestTemplate restTemplate;
    private final String baseUrl;

    public HttpClient(RestApiProperties properties, String baseUrl) {
        this.baseUrl = baseUrl;
        this.restTemplate = RestTemplateContext.getInstance().getRestTemplate();
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(3000);
        if (properties != null && properties.isEnableProxy()) {
            log.info("enable proxy {}//:{}:{}", new Object[]{properties.getProxyType(), properties.getProxyHost(), properties.getProxyPort()});
            requestFactory.setProxy(new Proxy(properties.getProxyType(), new InetSocketAddress(properties.getProxyHost(), properties.getProxyPort())));
        }
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
    }

    private String buildUrl(String api) {
        return this.baseUrl + api;
    }

    public String post(String api, JSON jsonObject) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String url = this.buildUrl(api);
        HttpEntity httpEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        ResponseEntity httpResponse = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        return (String)httpResponse.getBody();
    }

    public String get(String api, MultiValueMap<String, String> uriVariables) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String url = this.buildUrl(api);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)url);
        if (uriVariables != null) {
            uriComponentsBuilder = uriComponentsBuilder.queryParams(uriVariables);
        }
        URI uri = uriComponentsBuilder.build().toUri();
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity httpResponse = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, String.class);
        return (String)httpResponse.getBody();
    }
}

