/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.crypto;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AES {
    public static final String KEY_ALGORITHM = "AES";
    public static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private final Key key;
    private final AlgorithmParameters iv;
    private final String algorithm;

    public AES(String algorithm, Key key, AlgorithmParameters iv) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.algorithm = algorithm;
        this.key = key;
        this.iv = iv;
    }

    public AES(String algorithm, int generateKeySize) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.algorithm = algorithm;
        this.key = this.generateKey(generateKeySize);
        this.iv = this.generateIV(this.randomIv());
    }

    public AES(String algorithm, byte[] keys, byte[] ivs) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.algorithm = algorithm;
        this.key = this.convertToKey(keys);
        this.iv = this.generateIV(ivs);
    }

    public AES() throws Exception {
        this(CIPHER_ALGORITHM, 256);
    }

    public AES(int generateKeySize) throws Exception {
        this(CIPHER_ALGORITHM, generateKeySize);
    }

    public AES(byte[] keys, byte[] ivs) throws Exception {
        this(CIPHER_ALGORITHM, keys, ivs);
    }

    public AES(String key, String iv) throws Exception {
        this(CIPHER_ALGORITHM, key.getBytes(StandardCharsets.UTF_8), iv.getBytes(StandardCharsets.UTF_8));
    }

    private byte[] randomIv() {
        Random random = new Random();
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return bytes;
    }

    private SecretKey generateKey(int keySize) throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
        keyGenerator.init(keySize);
        return keyGenerator.generateKey();
    }

    private AlgorithmParameters generateIV(byte[] ivs) throws Exception {
        AlgorithmParameters params = AlgorithmParameters.getInstance(KEY_ALGORITHM);
        params.init(new IvParameterSpec(ivs));
        return params;
    }

    private Key convertToKey(byte[] keyBytes) {
        return new SecretKeySpec(keyBytes, KEY_ALGORITHM);
    }

    public byte[] getKey() {
        return this.key.getEncoded();
    }

    public byte[] getIv() throws IOException {
        return this.iv.getEncoded();
    }

    public byte[] encrypt(byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(1, this.key, this.iv);
        return cipher.doFinal(data);
    }

    public byte[] decrypt(byte[] encryptedData) throws Exception {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(2, this.key, this.iv);
        return cipher.doFinal(encryptedData);
    }
}

