/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.rest;

import com.codingapi.springboot.framework.rest.HttpClient;
import com.codingapi.springboot.framework.rest.param.RestParamBuilder;
import com.codingapi.springboot.framework.rest.properties.HttpProxyProperties;
import java.net.URI;
import java.util.Objects;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class SessionClient {
    private final HttpClient httpClient;
    private final HttpHeaders httpHeaders;

    public SessionClient(HttpProxyProperties properties) {
        HttpClient.IHttpResponseHandler responseHandler = new HttpClient.IHttpResponseHandler(){

            public HttpHeaders copyHeaders(HttpHeaders headers) {
                for (String key : headers.keySet()) {
                    if (key.equals("Set-Cookie")) {
                        SessionClient.this.httpHeaders.set("Cookie", String.join((CharSequence)";", Objects.requireNonNull(headers.get((Object)key))));
                        continue;
                    }
                    SessionClient.this.httpHeaders.set(key, String.join((CharSequence)";", Objects.requireNonNull(headers.get((Object)key))));
                }
                return SessionClient.this.httpHeaders;
            }

            @Override
            public String toResponse(HttpClient client, URI uri, ResponseEntity<String> response) {
                if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                    return (String)response.getBody();
                }
                if (response.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                    return (String)response.getBody();
                }
                if (response.getStatusCode().equals((Object)HttpStatus.FOUND)) {
                    HttpHeaders headers = response.getHeaders();
                    String location = Objects.requireNonNull(headers.getLocation()).toString();
                    String baseUrl = uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort();
                    String url = baseUrl + location;
                    return client.get(url, this.copyHeaders(headers), null);
                }
                return (String)response.getBody();
            }
        };
        this.httpClient = new HttpClient(properties, responseHandler);
        this.httpHeaders = new HttpHeaders();
    }

    public SessionClient() {
        this(null);
    }

    public SessionClient addHeader(String key, String value) {
        this.httpHeaders.add(key, value);
        return this;
    }

    public String post(String url, RestParamBuilder restParam) {
        return this.httpClient.post(url, this.httpHeaders, restParam.toFormRequest());
    }

    public String get(String url) {
        return this.httpClient.get(url, this.httpHeaders, null);
    }
}

