/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.rest.param;

import com.alibaba.fastjson.JSONObject;
import java.beans.PropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class RestParamBuilder {
    private final JSONObject jsonBody = new JSONObject();
    private final MultiValueMap<String, String> mapBody = new LinkedMultiValueMap();

    private RestParamBuilder() {
    }

    public static RestParamBuilder create() {
        return new RestParamBuilder();
    }

    public static RestParamBuilder parser(Object obj) {
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(obj.getClass());
        RestParamBuilder builder = RestParamBuilder.create();
        for (PropertyDescriptor descriptor : descriptors) {
            String name = descriptor.getName();
            Object value = PropertyUtils.getProperty((Object)obj, (String)name);
            if (value == null) continue;
            builder.add(name, value);
        }
        return builder;
    }

    public JSONObject toJsonRequest() {
        return this.jsonBody;
    }

    public MultiValueMap<String, String> toFormRequest() {
        return this.mapBody;
    }

    public RestParamBuilder add(String key, Object value) {
        this.jsonBody.put(key, value);
        this.mapBody.add((Object)key, (Object)value.toString());
        return this;
    }
}

