/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.handler;

import com.codingapi.springboot.framework.event.IEvent;
import com.codingapi.springboot.framework.handler.IHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApplicationHandlerUtils
implements IHandler<IEvent> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationHandlerUtils.class);
    private static ApplicationHandlerUtils instance;
    private List<IHandler<IEvent>> handlers = new ArrayList<IHandler<IEvent>>();

    private ApplicationHandlerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationHandlerUtils getInstance() {
        if (instance != null) return instance;
        Class<ApplicationHandlerUtils> clazz = ApplicationHandlerUtils.class;
        synchronized (ApplicationHandlerUtils.class) {
            if (instance != null) return instance;
            instance = new ApplicationHandlerUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addHandlers(List<IHandler> handlers) {
        if (handlers != null) {
            handlers.forEach(this::addHandler);
        }
    }

    public void addHandler(IHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    @Override
    public void handler(IEvent event) {
        for (IHandler<IEvent> handler : this.handlers) {
            String targetClassName = null;
            try {
                Class<?> targetClass;
                Class<?> eventClass = event.getClass();
                if (!eventClass.equals(targetClass = this.getHandlerEventClass(handler))) continue;
                targetClassName = targetClass.getName();
                handler.handler(event);
            }
            catch (Exception e) {
                if ("com.codingapi.springboot.framework.persistence.PersistenceEvent".equals(targetClassName)) {
                    throw e;
                }
                log.warn("handler exception", (Throwable)e);
                handler.error(e);
            }
        }
    }

    private Class<?> getHandlerEventClass(IHandler<IEvent> handler) {
        Type[] types;
        for (Type type : types = handler.getClass().getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            if (!(type instanceof ParameterizedType) || (actualTypeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()) == null) continue;
            return (Class)actualTypeArguments[0];
        }
        return null;
    }
}

