/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.rest;

import com.alibaba.fastjson.JSON;
import com.codingapi.springboot.framework.rest.HttpClient;
import com.codingapi.springboot.framework.rest.param.RestParamBuilder;
import com.codingapi.springboot.framework.rest.properties.HttpProxyProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;

public class RestClient {
    private static final Logger log = LoggerFactory.getLogger(RestClient.class);
    private final HttpHeaders httpHeaders;
    private final HttpClient httpClient;
    private final int retryCount;
    private final String emptyResponse;
    private final String baseUrl;

    public RestClient(HttpProxyProperties httpProxyProperties, String baseUrl, int retryCount, String emptyResponse, HttpClient.IHttpRequestHandler requestHandler, HttpClient.IHttpResponseHandler responseHandler) {
        this.baseUrl = baseUrl;
        this.retryCount = retryCount;
        this.httpClient = new HttpClient(httpProxyProperties, requestHandler, responseHandler);
        this.httpHeaders = new HttpHeaders();
        this.emptyResponse = emptyResponse;
        this.initHeaders();
    }

    public RestClient(String baseUrl) {
        this(null, baseUrl, 5, "{}", null, null);
    }

    private void initHeaders() {
        this.httpHeaders.setContentType(MediaType.APPLICATION_JSON);
    }

    private String toUrl(String api) {
        return this.baseUrl + api;
    }

    public String get(String api, HttpHeaders headers, MultiValueMap<String, String> requestParams) {
        for (int i = 0; i < this.retryCount; ++i) {
            try {
                return this.httpClient.get(this.toUrl(api), headers, requestParams);
            }
            catch (Exception e) {
                log.warn("api:{},error:{}", (Object)api, (Object)e.getMessage());
                this.sleep();
                continue;
            }
        }
        return this.emptyResponse;
    }

    public String get(String api, HttpHeaders headers, RestParamBuilder paramBuilder) {
        return this.get(api, headers, paramBuilder != null ? paramBuilder.toFormRequest() : null);
    }

    public String get(String api, RestParamBuilder paramBuilder) {
        return this.get(api, this.httpHeaders, paramBuilder);
    }

    public String get(String api) {
        return this.get(api, this.httpHeaders, (RestParamBuilder)null);
    }

    public String get(String api, HttpHeaders headers) {
        return this.get(api, headers, (RestParamBuilder)null);
    }

    private String _post(String api, HttpHeaders headers, JSON requestBody) {
        return this.httpClient.post(this.toUrl(api), headers, requestBody);
    }

    public String post(String api, JSON requestBody) {
        return this.post(api, this.httpHeaders, requestBody);
    }

    public String post(String api, RestParamBuilder paramBuilder) {
        return this.post(api, this.httpHeaders, (JSON)paramBuilder.toJsonRequest());
    }

    public String post(String api, HttpHeaders headers, JSON requestBody) {
        for (int i = 0; i < this.retryCount; ++i) {
            try {
                return this._post(api, headers, requestBody);
            }
            catch (Exception e) {
                log.warn("api:{},error:{}", (Object)api, (Object)e.getMessage());
                this.sleep();
                continue;
            }
        }
        return this.emptyResponse;
    }

    public String post(String api, HttpHeaders headers, RestParamBuilder paramBuilder) {
        return this.post(api, headers, (JSON)paramBuilder.toJsonRequest());
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }
}

