/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.dto.request;

import jakarta.servlet.http.HttpServletRequest;
import java.beans.PropertyDescriptor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class PageRequest
extends org.springframework.data.domain.PageRequest {
    private int current;
    private int pageSize;
    private final Map<String, Object> filters = new HashMap<String, Object>();
    private HttpServletRequest servletRequest;
    private org.springframework.data.domain.PageRequest pageRequest;

    public PageRequest(int current, int pageSize, Sort sort) {
        super(current > 0 ? current-- : 0, pageSize, sort);
        this.current = current;
        this.pageSize = pageSize;
        this.pageRequest = PageRequest.of((int)current, (int)pageSize, (Sort)sort);
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            this.servletRequest = attributes.getRequest();
            this.syncParameter();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void syncParameter() {
        Enumeration enumeration = this.servletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = this.servletRequest.getParameter(key);
            if (!StringUtils.hasText((String)value)) continue;
            this.filters.put(key, value);
        }
    }

    public PageRequest() {
        this(0, 20, Sort.unsorted());
    }

    public void setCurrent(int current) {
        this.current = current > 0 ? current - 1 : 0;
    }

    public String getParameter(String key) {
        return this.servletRequest.getParameter(key);
    }

    public String getParameter(String key, String defaultValue) {
        String result = this.servletRequest.getParameter(key);
        return result == null ? defaultValue : result;
    }

    public int getIntParameter(String key) {
        return Integer.parseInt(this.servletRequest.getParameter(key));
    }

    public int getIntParameter(String key, int defaultValue) {
        String result = this.servletRequest.getParameter(key);
        return result == null ? defaultValue : Integer.parseInt(result);
    }

    public Map<String, Object> getFilters() {
        return this.filters;
    }

    public String getStringFilter(String key) {
        return (String)this.filters.get(key);
    }

    public String getStringFilter(String key, String defaultValue) {
        String result = (String)this.filters.get(key);
        return result == null ? defaultValue : result;
    }

    public int getIntFilter(String key) {
        return Integer.parseInt((String)this.filters.get(key));
    }

    public int getIntFilter(String key, int defaultValue) {
        String result = (String)this.filters.get(key);
        return result == null ? defaultValue : Integer.parseInt(result);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Sort getSort() {
        return this.pageRequest.getSort();
    }

    public org.springframework.data.domain.PageRequest next() {
        return new PageRequest(this.current + 1, this.getPageSize(), this.getSort());
    }

    public org.springframework.data.domain.PageRequest previous() {
        return this.current == 0 ? this : new PageRequest(this.current - 1, this.getPageSize(), this.getSort());
    }

    public org.springframework.data.domain.PageRequest first() {
        return new PageRequest(0, this.getPageSize(), this.getSort());
    }

    public int getPageNumber() {
        return this.current;
    }

    public long getOffset() {
        return (long)this.current * (long)this.pageSize;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public Pageable previousOrFirst() {
        return this.pageRequest.previousOrFirst();
    }

    public boolean isPaged() {
        return this.pageRequest.isPaged();
    }

    public boolean isUnpaged() {
        return this.pageRequest.isUnpaged();
    }

    public Sort getSortOr(Sort sort) {
        return this.pageRequest.getSortOr(sort);
    }

    public Optional<Pageable> toOptional() {
        return this.pageRequest.toOptional();
    }

    public void addSort(Sort sort) {
        Sort nowSort = this.pageRequest.getSort();
        if (nowSort == Sort.unsorted()) {
            this.pageRequest = new PageRequest(this.getCurrent(), this.getPageSize(), sort);
        } else {
            this.pageRequest.getSort().and(sort);
        }
    }

    public PageRequest addFilter(String key, Object value) {
        this.filters.put(key, value);
        return this;
    }

    public boolean hasFilter() {
        return !this.filters.isEmpty();
    }

    public <T> Example<T> getExample(Class<T> clazz) {
        PropertyDescriptor[] descriptors;
        if (!this.hasFilter()) {
            return null;
        }
        Object entity = null;
        try {
            entity = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (PropertyDescriptor descriptor : descriptors = BeanUtils.getPropertyDescriptors(clazz)) {
            String name = descriptor.getName();
            Object value = this.filters.get(name);
            if (value == null) continue;
            try {
                descriptor.getWriteMethod().invoke(entity, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Example.of(entity);
    }

    public int getCurrent() {
        return this.current;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }
}

