/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.rest.param;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class RestParam {
    private final JSONObject jsonBody = new JSONObject();
    private final MultiValueMap<String, String> mapBody = new LinkedMultiValueMap();

    private RestParam() {
    }

    public static RestParam create() {
        return new RestParam();
    }

    public static RestParam parser(Object obj) {
        RestParam builder = RestParam.create();
        JSONObject object = (JSONObject)JSONObject.toJSON((Object)obj);
        RestParam.fetch(object, builder);
        return builder;
    }

    private static void fetch(JSONObject object, RestParam builder) {
        for (String key : object.keySet()) {
            Object value = object.getObject(key, Object.class);
            if (value == null) continue;
            builder.add(key, value);
            if (value instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)value;
                RestParam.fetch(jsonObject, builder);
            }
            if (!(value instanceof JSONArray)) continue;
            JSONArray jsonArray = (JSONArray)value;
            for (Object o : jsonArray) {
                if (!(o instanceof JSONObject)) continue;
                JSONObject jsonObject = (JSONObject)o;
                RestParam.fetch(jsonObject, builder);
            }
        }
    }

    public JSONObject toJsonRequest() {
        return this.jsonBody;
    }

    public MultiValueMap<String, String> toFormRequest() {
        return this.mapBody;
    }

    public RestParam add(String key, Object value) {
        return this.add(key, value, true);
    }

    public RestParam add(String key, Object value, boolean encode) {
        String stringValue = value.toString();
        String encodeValue = encode ? URLEncoder.encode(stringValue, StandardCharsets.UTF_8) : value.toString();
        this.jsonBody.put(key, value);
        this.mapBody.add((Object)key, (Object)encodeValue);
        return this;
    }
}

