/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.event;

import com.codingapi.springboot.framework.event.ApplicationHandlerUtils;
import com.codingapi.springboot.framework.event.DomainEvent;
import com.codingapi.springboot.framework.event.EventTraceContext;
import com.codingapi.springboot.framework.event.IHandler;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class SpringEventHandler
implements ApplicationListener<DomainEvent> {
    private static final Logger log = LoggerFactory.getLogger(SpringEventHandler.class);
    public static final String THREAD_KEY = "Handler.ThreadPools";
    private final ExecutorService executorService = Executors.newFixedThreadPool(Integer.parseInt(System.getProperty("Handler.ThreadPools", "10")));

    public SpringEventHandler(List<IHandler> handlers) {
        ApplicationHandlerUtils.getInstance().addHandlers(handlers);
    }

    public void onApplicationEvent(DomainEvent domainEvent) {
        String traceId = domainEvent.getTraceId();
        if (domainEvent.isSync()) {
            try {
                EventTraceContext.getInstance().createEventKey(traceId);
                ApplicationHandlerUtils.getInstance().handler(domainEvent.getEvent());
            }
            finally {
                EventTraceContext.getInstance().checkEventState();
            }
        } else {
            this.executorService.execute(() -> {
                try {
                    EventTraceContext.getInstance().createEventKey(traceId);
                    ApplicationHandlerUtils.getInstance().handler(domainEvent.getEvent());
                }
                finally {
                    EventTraceContext.getInstance().checkEventState();
                }
            });
        }
    }
}

