/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.event;

import com.codingapi.springboot.framework.event.IEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventStackContext {
    private final Map<String, List<Class<?>>> eventClassStack = new HashMap();
    private final Map<String, List<IEvent>> eventStack = new HashMap<String, List<IEvent>>();
    private static final EventStackContext instance = new EventStackContext();

    private EventStackContext() {
    }

    private void addEventClass(String traceId, IEvent event) {
        List<Class<?>> events = this.eventClassStack.get(traceId);
        if (events == null) {
            events = new ArrayList();
        }
        events.add(event.getClass());
        this.eventClassStack.put(traceId, events);
    }

    private void addEventStack(String traceId, IEvent event) {
        List<IEvent> events = this.eventStack.get(traceId);
        if (events == null) {
            events = new ArrayList<IEvent>();
        }
        events.add(event);
        this.eventStack.put(traceId, events);
    }

    void addEvent(String traceId, IEvent event) {
        this.addEventClass(traceId, event);
        this.addEventStack(traceId, event);
    }

    boolean checkEventLoop(String traceId, IEvent event) {
        List<Class<?>> events = this.eventClassStack.get(traceId);
        if (events != null) {
            return events.contains(event.getClass());
        }
        return false;
    }

    public List<IEvent> getEvents(String eventKey) {
        if (eventKey != null) {
            String traceId = eventKey.split("#")[0];
            return this.eventStack.get(traceId);
        }
        return null;
    }

    public List<Class<?>> getEventClasses(String eventKey) {
        if (eventKey != null) {
            String traceId = eventKey.split("#")[0];
            return this.eventClassStack.get(traceId);
        }
        return null;
    }

    void remove(String traceId) {
        this.eventStack.remove(traceId);
        this.eventClassStack.remove(traceId);
    }

    public static EventStackContext getInstance() {
        return instance;
    }
}

