/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.exception;

import com.codingapi.springboot.framework.exception.MessageContext;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

class LocaleMessage {
    private final MessageSource messageSource;

    public LocaleMessage(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void init() {
        MessageContext.getInstance().setExceptionLocaleMessage(this);
    }

    public String getMessage(String code) {
        return this.getMessage(code, new Object[0]);
    }

    public String getMessage(String code, String defaultMessage) {
        return this.getMessage(code, new Object[0], defaultMessage);
    }

    public String getMessage(String code, String defaultMessage, Locale locale) {
        return this.getMessage(code, new Object[0], defaultMessage, locale);
    }

    public String getMessage(String code, Locale locale) {
        return this.getMessage(code, new Object[0], "", locale);
    }

    public String getMessage(String code, Object[] args) {
        return this.getMessage(code, args, "");
    }

    public String getMessage(String code, Object[] args, Locale locale) {
        return this.getMessage(code, args, "", locale);
    }

    public String getMessage(String code, Object[] args, String defaultMessage) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.getMessage(code, args, defaultMessage, locale);
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(code, args, defaultMessage, locale);
    }
}

