/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.crypto;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSA {
    public static final String KEY_ALGORITHM = "RSA";
    private PrivateKey privateKey;
    private final PublicKey publicKey;

    public RSA() throws NoSuchAlgorithmException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPair keyPair = this.generateKey();
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
    }

    public RSA(KeyPair keyPair) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
    }

    public RSA(PrivateKey privateKey, PublicKey publicKey) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public RSA(byte[] privateKey, byte[] publicKey) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.privateKey = this.getPrivateKeyFromString(privateKey);
        this.publicKey = this.getPublicKeyFromString(publicKey);
    }

    public RSA(byte[] publicKey) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.publicKey = this.getPublicKeyFromString(publicKey);
    }

    public KeyPair generateKey() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyGen.initialize(2048);
        return keyGen.generateKeyPair();
    }

    private PrivateKey getPrivateKeyFromString(byte[] key) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(key);
        return keyFactory.generatePrivate(privateKeySpec);
    }

    private PublicKey getPublicKeyFromString(byte[] key) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(key);
        return keyFactory.generatePublic(publicKeySpec);
    }

    public byte[] getPrivateKey() {
        return this.privateKey.getEncoded();
    }

    public byte[] getPublicKey() {
        return this.publicKey.getEncoded();
    }

    public byte[] encrypt(byte[] text) throws Exception {
        byte[] cipherText = null;
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, this.publicKey);
        cipherText = cipher.doFinal(text);
        return cipherText;
    }

    public byte[] decrypt(byte[] text) throws Exception {
        byte[] dectyptedText = null;
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, this.privateKey);
        dectyptedText = cipher.doFinal(text);
        return dectyptedText;
    }
}

