/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.rest;

import com.codingapi.springboot.framework.utils.TrustAnyHttpClientFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class RestTemplateContext {
    private static RestTemplateContext instance;
    private final RestTemplate restTemplate;

    private RestTemplateContext() {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory(TrustAnyHttpClientFactory.createTrustAnyHttpClient());
        this.restTemplate = this.restTemplate((ClientHttpRequestFactory)requestFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RestTemplateContext getInstance() {
        if (instance != null) return instance;
        Class<RestTemplateContext> clazz = RestTemplateContext.class;
        synchronized (RestTemplateContext.class) {
            if (instance != null) return instance;
            try {
                instance = new RestTemplateContext();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return instance;
        }
    }

    public RestTemplate restTemplate(ClientHttpRequestFactory factory) {
        return new RestTemplate(factory);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }
}

