/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.rest;

import com.alibaba.fastjson.JSON;
import com.codingapi.springboot.framework.rest.HttpRequest;
import com.codingapi.springboot.framework.rest.Request;
import com.codingapi.springboot.framework.rest.param.RestParam;
import com.codingapi.springboot.framework.rest.properties.HttpProxyProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;

public class RestClient {
    private static final Logger log = LoggerFactory.getLogger(RestClient.class);
    private final HttpHeaders httpHeaders;
    private final HttpRequest httpRequest;
    private final int retryCount;
    private final String emptyResponse;
    private final String baseUrl;

    public RestClient(HttpProxyProperties httpProxyProperties, String baseUrl, int retryCount, String emptyResponse, HttpRequest.IHttpRequestHandler requestHandler, HttpRequest.IHttpResponseHandler responseHandler) {
        this.baseUrl = baseUrl;
        this.retryCount = retryCount;
        this.httpRequest = new HttpRequest(httpProxyProperties, requestHandler, responseHandler);
        this.httpHeaders = new HttpHeaders();
        this.emptyResponse = emptyResponse;
        this.initHeaders();
    }

    public RestClient(String baseUrl) {
        this(null, baseUrl, 5, "{}", null, null);
    }

    private void initHeaders() {
        this.httpHeaders.setContentType(MediaType.APPLICATION_JSON);
    }

    private String toUrl(String api) {
        return this.baseUrl + api;
    }

    public String get(String api, HttpHeaders headers, MultiValueMap<String, String> requestParams) {
        String url = this.toUrl(api);
        Request request = this.getGetRequest(url, headers, requestParams);
        for (int i = 0; i < this.retryCount; ++i) {
            try {
                return request.execute();
            }
            catch (Exception e) {
                log.warn("api:{},error:{}", (Object)api, (Object)e.getMessage());
                this.sleep();
                continue;
            }
        }
        return this.emptyResponse;
    }

    public String get(String api, HttpHeaders headers, RestParam paramBuilder) {
        return this.get(api, headers, paramBuilder != null ? paramBuilder.toGetRequest() : null);
    }

    public String get(String api, RestParam paramBuilder) {
        return this.get(api, this.httpHeaders, paramBuilder);
    }

    public String get(String api) {
        return this.get(api, this.httpHeaders, (RestParam)null);
    }

    public String get(String api, HttpHeaders headers) {
        return this.get(api, headers, (RestParam)null);
    }

    public Request getGetRequest(String api, HttpHeaders headers, MultiValueMap<String, String> requestParams) {
        return this.httpRequest.getGetRequest(api, headers, requestParams);
    }

    public Request getPostRequest(String api, HttpHeaders headers, JSON requestBody) {
        return this.httpRequest.getPostRequest(api, headers, requestBody);
    }

    public String post(String api, JSON requestBody) {
        return this.post(api, this.httpHeaders, requestBody);
    }

    public String post(String api, RestParam paramBuilder) {
        return this.post(api, this.httpHeaders, (JSON)paramBuilder.toJsonRequest());
    }

    public String post(String api, HttpHeaders headers, JSON requestBody) {
        String url = this.toUrl(api);
        Request request = this.getPostRequest(url, headers, requestBody);
        for (int i = 0; i < this.retryCount; ++i) {
            try {
                return request.execute();
            }
            catch (Exception e) {
                log.warn("api:{},error:{}", (Object)api, (Object)e.getMessage());
                this.sleep();
                continue;
            }
        }
        return this.emptyResponse;
    }

    public String post(String api, HttpHeaders headers, RestParam paramBuilder) {
        return this.post(api, headers, (JSON)paramBuilder.toJsonRequest());
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }
}

