/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.rest.param;

import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class RestParam {
    private final JSONObject jsonBody = new JSONObject();
    private final MultiValueMap<String, Object> mapBody = new LinkedMultiValueMap();

    private RestParam() {
    }

    public static RestParam create() {
        return new RestParam();
    }

    public static RestParam parser(Object obj) {
        RestParam builder = RestParam.create();
        JSONObject object = (JSONObject)JSONObject.toJSON((Object)obj);
        RestParam.fetch(object, builder);
        return builder;
    }

    private static void fetch(JSONObject object, RestParam builder) {
        for (String key : object.keySet()) {
            Object value = object.getObject(key, Object.class);
            if (value == null) continue;
            builder.add(key, value);
        }
    }

    public JSONObject toJsonRequest() {
        return this.jsonBody;
    }

    public MultiValueMap<String, Object> toFormRequest() {
        return this.mapBody;
    }

    public MultiValueMap<String, String> toGetRequest() {
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        for (String key : this.mapBody.keySet()) {
            List objectList = (List)this.mapBody.get((Object)key);
            ArrayList<String> stringList = new ArrayList<String>();
            for (Object object : objectList) {
                stringList.add(object.toString());
            }
            request.put((Object)key, stringList);
        }
        return request;
    }

    public RestParam add(String key, Object value) {
        return this.add(key, value, true);
    }

    public RestParam add(String key, Object value, boolean encode) {
        String stringValue = value.toString();
        String encodeValue = encode ? URLEncoder.encode(stringValue, "UTF-8") : value.toString();
        this.jsonBody.put(key, value);
        this.mapBody.add((Object)key, (Object)encodeValue);
        return this;
    }
}

