/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.dto.request;

import com.codingapi.springboot.framework.dto.offset.ICurrentOffset;
import com.codingapi.springboot.framework.dto.offset.context.CurrentPageOffsetContext;
import com.codingapi.springboot.framework.dto.request.Filter;
import com.codingapi.springboot.framework.dto.request.Relation;
import com.codingapi.springboot.framework.dto.request.RequestFilter;
import org.springframework.data.domain.Sort;

public class PageRequest
extends org.springframework.data.domain.PageRequest
implements ICurrentOffset {
    private int current;
    private int pageSize;
    private Sort sort;
    private final RequestFilter requestFilter = new RequestFilter();

    public PageRequest(int current, int pageSize, Sort sort) {
        super(current, pageSize, sort);
        this.current = current;
        this.pageSize = pageSize;
        this.sort = sort;
    }

    public PageRequest() {
        this(0, 20, Sort.unsorted());
    }

    @Override
    public void setCurrent(int current) {
        this.current = CurrentPageOffsetContext.getInstance().getCurrentPage(this, current);
    }

    public String getStringFilter(String key) {
        return this.requestFilter.getStringFilter(key);
    }

    public String getStringFilter(String key, String defaultValue) {
        return this.requestFilter.getStringFilter(key, defaultValue);
    }

    public int getIntFilter(String key) {
        return this.requestFilter.getIntFilter(key);
    }

    public int getIntFilter(String key, int defaultValue) {
        return this.requestFilter.getIntFilter(key, defaultValue);
    }

    public boolean hasFilter() {
        return this.requestFilter.hasFilter();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageNumber() {
        return this.current;
    }

    public long getOffset() {
        return (long)this.current * (long)this.pageSize;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public void addSort(Sort sort) {
        Sort nowSort = this.sort;
        if (nowSort == Sort.unsorted()) {
            this.sort = sort;
        } else {
            this.sort.and(sort);
        }
    }

    public void removeFilter(String key) {
        this.requestFilter.removeFilter(key);
    }

    public PageRequest addFilter(String key, Relation relation, Object ... value) {
        this.requestFilter.addFilter(key, relation, value);
        return this;
    }

    public PageRequest addFilter(String key, Object ... value) {
        this.requestFilter.addFilter(key, value);
        return this;
    }

    public PageRequest andFilter(Filter ... filters) {
        this.requestFilter.andFilters(filters);
        return this;
    }

    public PageRequest orFilters(Filter ... filters) {
        this.requestFilter.orFilters(filters);
        return this;
    }

    public static PageRequest of(int page, int size) {
        return new PageRequest(page, size, Sort.unsorted());
    }

    public static PageRequest of(int page, int size, Sort sort) {
        return new PageRequest(page, size, sort);
    }

    public int getCurrent() {
        return this.current;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Sort getSort() {
        return this.sort;
    }

    public RequestFilter getRequestFilter() {
        return this.requestFilter;
    }
}

