/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.event;

import com.codingapi.springboot.framework.event.IEvent;
import com.codingapi.springboot.framework.event.IHandler;
import com.codingapi.springboot.framework.exception.EventException;
import com.codingapi.springboot.framework.exception.EventLoopException;
import java.util.ArrayList;
import java.util.List;

class ApplicationHandlerUtils
implements IHandler<IEvent> {
    private static ApplicationHandlerUtils instance;
    private final List<IHandler<IEvent>> handlers = new ArrayList<IHandler<IEvent>>();

    private ApplicationHandlerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationHandlerUtils getInstance() {
        if (instance != null) return instance;
        Class<ApplicationHandlerUtils> clazz = ApplicationHandlerUtils.class;
        synchronized (ApplicationHandlerUtils.class) {
            if (instance != null) return instance;
            instance = new ApplicationHandlerUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addHandlers(List<IHandler> handlers) {
        if (handlers != null) {
            handlers.forEach(this::addHandler);
        }
    }

    public void addHandler(IHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    @Override
    public void handler(IEvent event) {
        Class<?> eventClass = event.getClass();
        ArrayList<Exception> errorStack = new ArrayList<Exception>();
        boolean throwException = false;
        for (IHandler<IEvent> handler : this.handlers) {
            try {
                Class<?> targetClass = handler.getHandlerEventClass();
                if (!eventClass.equals(targetClass)) continue;
                handler.handler(event);
            }
            catch (Exception e) {
                if (e instanceof EventLoopException) {
                    throw e;
                }
                try {
                    handler.error(e);
                    errorStack.add(e);
                }
                catch (Exception err) {
                    throwException = true;
                    errorStack.add(err);
                }
            }
        }
        if (throwException) {
            throw new EventException(errorStack);
        }
    }
}

