/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.dto.request;

import com.codingapi.springboot.framework.dto.request.Relation;

public class Filter {
    public static final String FILTER_OR_KEY = "FILTER_OR_KEY";
    public static final String FILTER_AND_KEY = "FILTER_AND_KEY";
    private String key;
    private Object[] value;
    private Relation relation;

    public Filter(String key, Relation relation, Object ... value) {
        this.key = key;
        this.value = value;
        this.relation = relation;
    }

    public Filter(String key, Object ... value) {
        this(key, Relation.EQUAL, value);
    }

    public Filter(String key, Filter ... value) {
        this(key, null, (Object[])value);
    }

    public static Filter as(String key, Relation relation, Object ... value) {
        return new Filter(key, relation, value);
    }

    public static Filter as(String key, Object ... value) {
        return new Filter(key, value);
    }

    public static Filter and(Filter ... value) {
        return new Filter(FILTER_AND_KEY, value);
    }

    public static Filter or(Filter ... value) {
        return new Filter(FILTER_OR_KEY, value);
    }

    public boolean isEqual() {
        return this.relation == Relation.EQUAL;
    }

    public boolean isNotEqual() {
        return this.relation == Relation.NOT_EQUAL;
    }

    public boolean isLike() {
        return this.relation == Relation.LIKE;
    }

    public boolean isLeftLike() {
        return this.relation == Relation.LEFT_LIKE;
    }

    public boolean isRightLike() {
        return this.relation == Relation.RIGHT_LIKE;
    }

    public boolean isBetween() {
        return this.relation == Relation.BETWEEN;
    }

    public boolean isIn() {
        return this.relation == Relation.IN;
    }

    public boolean isOrFilters() {
        return FILTER_OR_KEY.equals(this.key);
    }

    public boolean isAndFilters() {
        return FILTER_AND_KEY.equals(this.key);
    }

    public boolean isGreaterThan() {
        return this.relation == Relation.GREATER_THAN;
    }

    public boolean isLessThan() {
        return this.relation == Relation.LESS_THAN;
    }

    public boolean isGreaterThanEqual() {
        return this.relation == Relation.GREATER_THAN_EQUAL;
    }

    public boolean isLessThanEqual() {
        return this.relation == Relation.LESS_THAN_EQUAL;
    }

    public Object getFilterValue(Class<?> clazz) {
        Object val = this.value[0];
        if (val instanceof String) {
            if (clazz == Integer.class) {
                return Integer.parseInt((String)val);
            }
            if (clazz == Long.class) {
                return Long.parseLong((String)val);
            }
            if (clazz == Double.class) {
                return Double.parseDouble((String)val);
            }
            if (clazz == Float.class) {
                return Float.valueOf(Float.parseFloat((String)val));
            }
        }
        return this.value[0];
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(Object[] value) {
        this.value = value;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getValue() {
        return this.value;
    }

    public Relation getRelation() {
        return this.relation;
    }
}

