/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.event;

import com.codingapi.springboot.framework.event.IEvent;
import com.codingapi.springboot.framework.event.IHandler;
import com.codingapi.springboot.framework.exception.EventException;
import com.codingapi.springboot.framework.exception.EventLoopException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.ResolvableType;

class ApplicationHandlerUtils
implements IHandler<IEvent> {
    private static ApplicationHandlerUtils instance;
    private final List<IHandler<IEvent>> handlers = new ArrayList<IHandler<IEvent>>();

    private ApplicationHandlerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationHandlerUtils getInstance() {
        if (instance != null) return instance;
        Class<ApplicationHandlerUtils> clazz = ApplicationHandlerUtils.class;
        synchronized (ApplicationHandlerUtils.class) {
            if (instance != null) return instance;
            instance = new ApplicationHandlerUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addHandlers(List<IHandler> handlers) {
        if (handlers != null) {
            handlers.forEach(this::addHandler);
        }
    }

    public void addHandler(IHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    private Class<?> getHandlerEventClass(IHandler<?> handler) {
        ResolvableType resolvableType = ResolvableType.forClass(handler.getClass()).as(IHandler.class);
        return resolvableType.getGeneric(new int[]{0}).resolve();
    }

    @Override
    public void handler(IEvent event) {
        Class<?> eventClass = event.getClass();
        List matchHandlers = this.handlers.stream().filter(handler -> {
            Class<?> targetClass = this.getHandlerEventClass((IHandler<?>)handler);
            return targetClass.isAssignableFrom(eventClass);
        }).sorted(Comparator.comparingInt(IHandler::order)).collect(Collectors.toList());
        if (matchHandlers.isEmpty()) {
            return;
        }
        ArrayList<Exception> errorStack = new ArrayList<Exception>();
        boolean hasThrowException = false;
        for (IHandler handler2 : matchHandlers) {
            try {
                handler2.handler(event);
            }
            catch (Exception e) {
                if (e instanceof EventLoopException) {
                    throw e;
                }
                try {
                    handler2.error(e);
                    errorStack.add(e);
                }
                catch (Exception err) {
                    hasThrowException = true;
                    errorStack.add(err);
                }
            }
        }
        if (hasThrowException) {
            throw new EventException(errorStack);
        }
    }
}

