/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.event;

import com.codingapi.springboot.framework.event.EventStackContext;
import com.codingapi.springboot.framework.event.IEvent;
import com.codingapi.springboot.framework.exception.EventLoopException;
import com.codingapi.springboot.framework.utils.RandomGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class EventTraceContext {
    private static final EventTraceContext instance = new EventTraceContext();
    private final Set<String> traceKeys = new HashSet<String>();
    private final ThreadLocal<String> threadLocal = new ThreadLocal();
    private final Map<String, Boolean> eventKeyState = new HashMap<String, Boolean>();

    private EventTraceContext() {
    }

    String getOrCreateTrace() {
        String eventKey = this.threadLocal.get();
        if (eventKey != null) {
            return eventKey.split("#")[0];
        }
        String traceId = UUID.randomUUID().toString().replaceAll("-", "");
        this.traceKeys.add(traceId);
        return traceId;
    }

    public String getEventKey() {
        return this.threadLocal.get();
    }

    void createEventKey(String traceId) {
        String eventKey = traceId + "#" + RandomGenerator.randomString(8);
        this.eventKeyState.put(eventKey, false);
        this.threadLocal.set(eventKey);
    }

    void checkEventState() {
        String eventKey = this.threadLocal.get();
        if (eventKey != null) {
            boolean state = this.eventKeyState.get(eventKey);
            if (!state) {
                String traceId = eventKey.split("#")[0];
                this.traceKeys.remove(traceId);
                EventStackContext.getInstance().remove(traceId);
            }
            this.eventKeyState.remove(eventKey);
        }
        this.threadLocal.remove();
    }

    void addEvent(String traceId, IEvent event) {
        boolean hasEventLoop = EventStackContext.getInstance().checkEventLoop(traceId, event);
        if (hasEventLoop) {
            List<Class<?>> stack = EventStackContext.getInstance().getEventClasses(traceId);
            this.traceKeys.remove(traceId);
            EventStackContext.getInstance().remove(traceId);
            this.eventKeyState.remove(traceId);
            this.threadLocal.remove();
            throw new EventLoopException(stack, event);
        }
        EventStackContext.getInstance().addEvent(traceId, event);
    }

    public void clearTrace() {
        String eventKey = this.threadLocal.get();
        if (eventKey != null) {
            String traceId = eventKey.split("#")[0];
            this.traceKeys.remove(traceId);
            EventStackContext.getInstance().remove(traceId);
            this.eventKeyState.remove(eventKey);
            this.threadLocal.remove();
        }
    }

    public static EventTraceContext getInstance() {
        return instance;
    }
}

