/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.codingapi.springboot.framework.rest.Request;
import com.codingapi.springboot.framework.rest.RestTemplateContext;
import com.codingapi.springboot.framework.rest.properties.HttpProxyProperties;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplateHandler;

public class HttpRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpRequest.class);
    private final RestTemplate restTemplate;
    private final IHttpResponseHandler responseHandler;
    private final IHttpRequestHandler requestHandler;
    private static final IHttpResponseHandler defaultResponseHandler = new IHttpResponseHandler(){

        public HttpHeaders copyHeaders(HttpHeaders headers) {
            HttpHeaders httpHeaders = new HttpHeaders();
            for (String key : headers.keySet()) {
                httpHeaders.set(key, String.join((CharSequence)";", Objects.requireNonNull(headers.get((Object)key))));
            }
            return httpHeaders;
        }

        @Override
        public String handler(HttpRequest client, String url, ResponseEntity<String> response) {
            if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                return (String)response.getBody();
            }
            if (response.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                return (String)response.getBody();
            }
            if (response.getStatusCode().equals((Object)HttpStatus.FOUND)) {
                URI uri = URI.create(url);
                HttpHeaders headers = response.getHeaders();
                String location = Objects.requireNonNull(headers.getLocation()).toString();
                String baseUrl = uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort();
                String locationUrl = baseUrl + location;
                return client.get(locationUrl, this.copyHeaders(headers), null);
            }
            return (String)response.getBody();
        }
    };
    private static final IHttpRequestHandler defaultRequestHandler = new IHttpRequestHandler(){

        @Override
        public String handler(HttpRequest client, String uri, HttpMethod method, HttpHeaders headers, HttpEntity<?> httpEntity) {
            return uri;
        }
    };
    private static final ResponseErrorHandler defaultErrorHandler = new DefaultResponseErrorHandler(){

        public boolean hasError(ClientHttpResponse response) throws IOException {
            if (response.getStatusCode() == HttpStatus.NOT_FOUND) {
                return false;
            }
            return super.hasError(response);
        }
    };

    public HttpRequest() {
        this(null, defaultRequestHandler, defaultResponseHandler);
    }

    public HttpRequest(IHttpRequestHandler requestHandler, IHttpResponseHandler responseHandler) {
        this(null, requestHandler, responseHandler);
    }

    public HttpRequest(HttpProxyProperties properties) {
        this(properties, defaultRequestHandler, defaultResponseHandler);
    }

    public HttpRequest(HttpProxyProperties properties, IHttpRequestHandler requestHandler, IHttpResponseHandler responseHandler) {
        this.requestHandler = requestHandler == null ? defaultRequestHandler : requestHandler;
        this.responseHandler = responseHandler == null ? defaultResponseHandler : responseHandler;
        this.restTemplate = RestTemplateContext.getInstance().getRestTemplate();
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(3000);
        if (properties != null && properties.isEnableProxy()) {
            log.info("enable proxy {}//:{}:{}", new Object[]{properties.getProxyType(), properties.getProxyHost(), properties.getProxyPort()});
            requestFactory.setProxy(new Proxy(properties.getProxyType(), new InetSocketAddress(properties.getProxyHost(), properties.getProxyPort())));
        }
        this.restTemplate.setErrorHandler(defaultErrorHandler);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        DefaultUriBuilderFactory uriBuilderFactory = new DefaultUriBuilderFactory();
        uriBuilderFactory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.NONE);
        this.restTemplate.setUriTemplateHandler((UriTemplateHandler)uriBuilderFactory);
    }

    public Request getPostRequest(String url, HttpHeaders headers, JSON jsonObject) {
        HttpEntity httpEntity = new HttpEntity((Object)jsonObject.toString(new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), (MultiValueMap)headers);
        String requestUrl = this.requestHandler.handler(this, url, HttpMethod.POST, headers, httpEntity);
        return () -> {
            ResponseEntity httpResponse = this.restTemplate.exchange(requestUrl, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            return this.responseHandler.handler(this, url, (ResponseEntity<String>)httpResponse);
        };
    }

    public Request getPostRequest(String url, HttpHeaders headers, MultiValueMap<String, String> formData) {
        HttpEntity httpEntity = new HttpEntity(formData, (MultiValueMap)headers);
        String requestUrl = this.requestHandler.handler(this, url, HttpMethod.POST, headers, httpEntity);
        return () -> {
            ResponseEntity httpResponse = this.restTemplate.exchange(requestUrl, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            return this.responseHandler.handler(this, url, (ResponseEntity<String>)httpResponse);
        };
    }

    public Request getGetRequest(String url, HttpHeaders headers, MultiValueMap<String, String> uriVariables) {
        String requestUrl;
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        if (uriVariables != null && !uriVariables.isEmpty()) {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)url).queryParams(uriVariables).build(true).toUri();
            requestUrl = this.requestHandler.handler(this, uri.toString(), HttpMethod.GET, headers, httpEntity);
        } else {
            requestUrl = this.requestHandler.handler(this, url, HttpMethod.GET, headers, httpEntity);
        }
        return () -> {
            ResponseEntity httpResponse = this.restTemplate.exchange(requestUrl, HttpMethod.GET, httpEntity, String.class, new Object[0]);
            return this.responseHandler.handler(this, url, (ResponseEntity<String>)httpResponse);
        };
    }

    protected String get(String url, HttpHeaders headers, MultiValueMap<String, String> uriVariables) {
        ResponseEntity httpResponse;
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        if (uriVariables != null && !uriVariables.isEmpty()) {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)url).queryParams(uriVariables).build(true).toUri();
            String requestUrl = this.requestHandler.handler(this, uri.toString(), HttpMethod.GET, headers, httpEntity);
            httpResponse = this.restTemplate.exchange(requestUrl, HttpMethod.GET, httpEntity, String.class, new Object[0]);
        } else {
            String requestUrl = this.requestHandler.handler(this, url, HttpMethod.GET, headers, httpEntity);
            httpResponse = this.restTemplate.exchange(requestUrl, HttpMethod.GET, httpEntity, String.class, new Object[0]);
        }
        return this.responseHandler.handler(this, url, (ResponseEntity<String>)httpResponse);
    }

    public static interface IHttpRequestHandler {
        public String handler(HttpRequest var1, String var2, HttpMethod var3, HttpHeaders var4, HttpEntity<?> var5);
    }

    public static interface IHttpResponseHandler {
        public String handler(HttpRequest var1, String var2, ResponseEntity<String> var3);
    }
}

