/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.trigger;

import com.codingapi.springboot.framework.trigger.Trigger;
import com.codingapi.springboot.framework.trigger.TriggerHandler;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerContext {
    private static final Logger log = LoggerFactory.getLogger(TriggerContext.class);
    private static final TriggerContext instance = new TriggerContext();
    private final Map<Class<? extends Trigger>, List<TriggerHandler>> triggers = new ConcurrentHashMap<Class<? extends Trigger>, List<TriggerHandler>>();

    public static TriggerContext getInstance() {
        return instance;
    }

    private TriggerContext() {
    }

    public void addTrigger(TriggerHandler handler) {
        Class<? extends Trigger> clazz = this.getTriggerClass(handler.getClass());
        List<TriggerHandler> triggerList = this.triggers.get(clazz);
        if (triggerList == null) {
            triggerList = new CopyOnWriteArrayList<TriggerHandler>();
            this.triggers.put(clazz, triggerList);
        }
        triggerList.add(handler);
    }

    private Class<? extends Trigger> getTriggerClass(Class<?> handler) {
        for (Class<?> superInterface : handler.getInterfaces()) {
            if (!superInterface.equals(TriggerHandler.class)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)handler.getGenericInterfaces()[0];
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return this.getTriggerClass(handler.getSuperclass());
    }

    public void trigger(Trigger trigger) {
        Class<?> clazz = trigger.getClass();
        List<TriggerHandler> triggerHandlerList = this.triggers.get(clazz);
        if (triggerHandlerList != null) {
            for (TriggerHandler handler : triggerHandlerList) {
                Class<? extends Trigger> triggerClass = this.getTriggerClass(handler.getClass());
                if (!triggerClass.equals(clazz)) continue;
                try {
                    boolean canTrigger = handler.preTrigger(trigger);
                    if (canTrigger) {
                        handler.trigger(trigger);
                    }
                    if (!handler.remove(trigger, canTrigger)) continue;
                    triggerHandlerList.remove(handler);
                }
                catch (Exception e) {
                    log.warn("trigger error", (Throwable)e);
                }
            }
        }
    }

    public void clear(Class<? extends Trigger> clazz) {
        this.triggers.get(clazz).clear();
    }

    public boolean isEmpty(Class<? extends Trigger> clazz) {
        return this.triggers.get(clazz).isEmpty();
    }
}

