/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.dto.request;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class PageRequest
extends org.springframework.data.domain.PageRequest {
    private int current;
    private int pageSize;
    private final Map<String, Filter> filters = new HashMap<String, Filter>();
    private HttpServletRequest servletRequest;
    private org.springframework.data.domain.PageRequest pageRequest;

    public PageRequest(int current, int pageSize, Sort sort) {
        super(current > 0 ? current-- : 0, pageSize, sort);
        this.current = current;
        this.pageSize = pageSize;
        this.pageRequest = PageRequest.of((int)current, (int)pageSize, (Sort)sort);
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            this.servletRequest = attributes.getRequest();
            this.syncParameter();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void syncParameter() {
        Enumeration enumeration = this.servletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = this.servletRequest.getParameter(key);
            if (!StringUtils.hasText((String)value)) continue;
            this.addFilter(key, value);
        }
    }

    public PageRequest() {
        this(0, 20, Sort.unsorted());
    }

    public void setCurrent(int current) {
        this.current = current > 0 ? current - 1 : 0;
    }

    public String getParameter(String key) {
        return this.servletRequest.getParameter(key);
    }

    public String getParameter(String key, String defaultValue) {
        String result = this.servletRequest.getParameter(key);
        return result == null ? defaultValue : result;
    }

    public int getIntParameter(String key) {
        return Integer.parseInt(this.servletRequest.getParameter(key));
    }

    public int getIntParameter(String key, int defaultValue) {
        String result = this.servletRequest.getParameter(key);
        return result == null ? defaultValue : Integer.parseInt(result);
    }

    public String getStringFilter(String key) {
        Filter filter = this.filters.get(key);
        if (filter != null) {
            return (String)filter.getValue()[0];
        }
        return null;
    }

    public String getStringFilter(String key, String defaultValue) {
        String value = this.getStringFilter(key);
        if (!StringUtils.hasText((String)value)) {
            return defaultValue;
        }
        return value;
    }

    public int getIntFilter(String key) {
        Filter filter = this.filters.get(key);
        if (filter != null) {
            String value = (String)filter.getValue()[0];
            if (StringUtils.hasText((String)value)) {
                return Integer.parseInt(value);
            }
            return 0;
        }
        return 0;
    }

    public int getIntFilter(String key, int defaultValue) {
        int value = this.getIntFilter(key);
        if (value == 0) {
            return defaultValue;
        }
        return value;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Sort getSort() {
        return this.pageRequest.getSort();
    }

    public org.springframework.data.domain.PageRequest next() {
        return new PageRequest(this.current + 1, this.getPageSize(), this.getSort());
    }

    public org.springframework.data.domain.PageRequest previous() {
        return this.current == 0 ? this : new PageRequest(this.current - 1, this.getPageSize(), this.getSort());
    }

    public org.springframework.data.domain.PageRequest first() {
        return new PageRequest(0, this.getPageSize(), this.getSort());
    }

    public int getPageNumber() {
        return this.current;
    }

    public long getOffset() {
        return (long)this.current * (long)this.pageSize;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public Pageable previousOrFirst() {
        return this.pageRequest.previousOrFirst();
    }

    public boolean isPaged() {
        return this.pageRequest.isPaged();
    }

    public boolean isUnpaged() {
        return this.pageRequest.isUnpaged();
    }

    public Sort getSortOr(Sort sort) {
        return this.pageRequest.getSortOr(sort);
    }

    public Optional<Pageable> toOptional() {
        return this.pageRequest.toOptional();
    }

    public void addSort(Sort sort) {
        Sort nowSort = this.pageRequest.getSort();
        if (nowSort == Sort.unsorted()) {
            this.pageRequest = new PageRequest(this.getCurrent(), this.getPageSize(), sort);
        } else {
            this.pageRequest.getSort().and(sort);
        }
    }

    public PageRequest addFilter(String key, FilterRelation relation, Object ... value) {
        this.putFilter(key, relation, value);
        return this;
    }

    public PageRequest addFilter(String key, Object ... value) {
        return this.addFilter(key, FilterRelation.EUQAL, value);
    }

    public boolean hasFilter() {
        return !this.filters.isEmpty();
    }

    private void putFilter(String key, FilterRelation relation, Object ... val) {
        Filter filter = new Filter();
        filter.setKey(key);
        filter.setValue(val);
        filter.setRelation(relation);
        this.filters.put(key, filter);
    }

    public int getCurrent() {
        return this.current;
    }

    public Map<String, Filter> getFilters() {
        return this.filters;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public static class Filter {
        private String key;
        private Object[] value;
        private FilterRelation relation;

        public boolean isEqual() {
            return this.relation == FilterRelation.EUQAL;
        }

        public boolean isLike() {
            return this.relation == FilterRelation.LIKE;
        }

        public boolean isBetween() {
            return this.relation == FilterRelation.BETWEEN;
        }

        public boolean isIn() {
            return this.relation == FilterRelation.IN;
        }

        public boolean isGreaterThan() {
            return this.relation == FilterRelation.GREATER_THAN;
        }

        public boolean isLessThan() {
            return this.relation == FilterRelation.LESS_THAN;
        }

        public boolean isGreaterThanEqual() {
            return this.relation == FilterRelation.GREATER_THAN_EQUAL;
        }

        public boolean isLessThanEqual() {
            return this.relation == FilterRelation.LESS_THAN_EQUAL;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(Object[] value) {
            this.value = value;
        }

        public void setRelation(FilterRelation relation) {
            this.relation = relation;
        }

        public String getKey() {
            return this.key;
        }

        public Object[] getValue() {
            return this.value;
        }

        public FilterRelation getRelation() {
            return this.relation;
        }
    }

    public static enum FilterRelation {
        EUQAL,
        LIKE,
        BETWEEN,
        IN,
        GREATER_THAN,
        LESS_THAN,
        GREATER_THAN_EQUAL,
        LESS_THAN_EQUAL;

    }
}

