/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.rest;

import com.alibaba.fastjson.JSON;
import com.codingapi.springboot.framework.rest.HttpClient;
import com.codingapi.springboot.framework.rest.HttpRequest;
import com.codingapi.springboot.framework.rest.param.RestParam;
import com.codingapi.springboot.framework.rest.properties.HttpProxyProperties;
import java.net.URI;
import java.util.Objects;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

public class SessionClient {
    private final HttpClient httpClient;
    private final HttpHeaders httpHeaders;

    public SessionClient(HttpProxyProperties properties) {
        HttpRequest.IHttpResponseHandler responseHandler = new HttpRequest.IHttpResponseHandler(){

            public HttpHeaders copyHeaders(HttpHeaders headers) {
                for (String key : headers.keySet()) {
                    if (key.equals("Set-Cookie")) {
                        SessionClient.this.httpHeaders.set("Cookie", String.join((CharSequence)";", Objects.requireNonNull(headers.get((Object)key))));
                        continue;
                    }
                    SessionClient.this.httpHeaders.set(key, String.join((CharSequence)";", Objects.requireNonNull(headers.get((Object)key))));
                }
                return SessionClient.this.httpHeaders;
            }

            @Override
            public String handler(HttpRequest client, String url, ResponseEntity<String> response) {
                if (response.getStatusCode().equals(HttpStatus.OK)) {
                    return (String)response.getBody();
                }
                if (response.getStatusCode().equals(HttpStatus.NOT_FOUND)) {
                    return (String)response.getBody();
                }
                if (response.getStatusCode().equals(HttpStatus.FOUND)) {
                    URI uri = URI.create(url);
                    HttpHeaders headers = response.getHeaders();
                    String location = Objects.requireNonNull(headers.getLocation()).toString();
                    String baseUrl = uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort();
                    String locationUrl = baseUrl + location;
                    return client.get(locationUrl, this.copyHeaders(headers), null);
                }
                return (String)response.getBody();
            }
        };
        this.httpClient = new HttpClient(properties, null, responseHandler);
        this.httpHeaders = new HttpHeaders();
    }

    public SessionClient() {
        this(null);
    }

    public SessionClient addHeader(String key, String value) {
        this.httpHeaders.add(key, value);
        return this;
    }

    public String postForm(String url, RestParam restParam) {
        this.httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return this.httpClient.post(url, this.httpHeaders, restParam.toFormRequest());
    }

    public String postJson(String url, RestParam restParam) {
        this.httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        return this.httpClient.post(url, this.httpHeaders, (JSON)restParam.toJsonRequest());
    }

    public String postJson(String url, JSON requestBody) {
        this.httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        return this.httpClient.post(url, this.httpHeaders, requestBody);
    }

    public String getJson(String url) {
        return this.getJson(url, null);
    }

    public String getHtml(String url) {
        return this.getHtml(url, null);
    }

    public String getHtml(String url, RestParam restParam) {
        this.httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return this.httpClient.get(url, this.httpHeaders, restParam != null ? restParam.toFormRequest() : null);
    }

    public String getJson(String url, RestParam restParam) {
        this.httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        return this.httpClient.get(url, this.httpHeaders, restParam != null ? restParam.toFormRequest() : null);
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }
}

