/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.dto.request;

import com.codingapi.springboot.framework.dto.request.Filter;
import com.codingapi.springboot.framework.dto.request.Relation;
import com.codingapi.springboot.framework.dto.request.RequestFilter;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageRequest
extends org.springframework.data.domain.PageRequest {
    private int current;
    private int pageSize;
    private final RequestFilter requestFilter = new RequestFilter();
    private org.springframework.data.domain.PageRequest pageRequest;

    public PageRequest(int current, int pageSize, Sort sort) {
        super(current, pageSize, sort);
        this.current = current;
        this.pageSize = pageSize;
        this.pageRequest = org.springframework.data.domain.PageRequest.of((int)current, (int)pageSize, (Sort)sort);
    }

    public PageRequest() {
        this(0, 20, Sort.unsorted());
    }

    public String getStringFilter(String key) {
        return this.requestFilter.getStringFilter(key);
    }

    public String getStringFilter(String key, String defaultValue) {
        return this.requestFilter.getStringFilter(key, defaultValue);
    }

    public int getIntFilter(String key) {
        return this.requestFilter.getIntFilter(key);
    }

    public int getIntFilter(String key, int defaultValue) {
        return this.requestFilter.getIntFilter(key, defaultValue);
    }

    public boolean hasFilter() {
        return this.requestFilter.hasFilter();
    }

    public Sort getSort() {
        return this.pageRequest.getSort();
    }

    public PageRequest next() {
        return new PageRequest(this.current + 1, this.getPageSize(), this.getSort());
    }

    public PageRequest previous() {
        return this.current == 0 ? this : new PageRequest(this.current - 1, this.getPageSize(), this.getSort());
    }

    public PageRequest first() {
        return new PageRequest(0, this.getPageSize(), this.getSort());
    }

    public int getPageNumber() {
        return this.current;
    }

    public long getOffset() {
        return (long)this.current * (long)this.pageSize;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public Pageable previousOrFirst() {
        return this.pageRequest.previousOrFirst();
    }

    public boolean isPaged() {
        return this.pageRequest.isPaged();
    }

    public boolean isUnpaged() {
        return this.pageRequest.isUnpaged();
    }

    public Sort getSortOr(Sort sort) {
        return this.pageRequest.getSortOr(sort);
    }

    public Optional<Pageable> toOptional() {
        return this.pageRequest.toOptional();
    }

    public void addSort(Sort sort) {
        Sort nowSort = this.pageRequest.getSort();
        if (nowSort == Sort.unsorted()) {
            this.pageRequest = new PageRequest(this.getCurrent(), this.getPageSize(), sort);
        } else {
            this.pageRequest.getSort().and(sort);
        }
    }

    public void removeFilter(String key) {
        this.requestFilter.removeFilter(key);
    }

    public PageRequest addFilter(String key, Relation relation, Object ... value) {
        this.requestFilter.addFilter(key, relation, value);
        return this;
    }

    public PageRequest addFilter(String key, Object ... value) {
        this.requestFilter.addFilter(key, value);
        return this;
    }

    public PageRequest andFilter(Filter ... filters) {
        this.requestFilter.andFilters(filters);
        return this;
    }

    public PageRequest orFilters(Filter ... filters) {
        this.requestFilter.orFilters(filters);
        return this;
    }

    public static PageRequest of(int page, int size) {
        return new PageRequest(page, size, Sort.unsorted());
    }

    public static PageRequest of(int page, int size, Sort sort) {
        return new PageRequest(page, size, sort);
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public RequestFilter getRequestFilter() {
        return this.requestFilter;
    }
}

