/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.dto.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.codingapi.springboot.framework.dto.request.Filter;
import com.codingapi.springboot.framework.dto.request.PageRequest;
import com.codingapi.springboot.framework.dto.request.Relation;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SearchRequest {
    private int current;
    private int pageSize;
    private final HttpServletRequest request;
    private final List<String> removeKeys = new ArrayList<String>();
    private final PageRequest pageRequest;

    public SearchRequest() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        this.request = attributes.getRequest();
        this.pageRequest = new PageRequest();
    }

    public void setCurrent(int current) {
        this.current = current - 1;
        this.removeKeys.add("current");
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.removeKeys.add("pageSize");
    }

    public void addSort(Sort sort) {
        this.pageRequest.addSort(sort);
    }

    public void removeFilter(String key) {
        this.pageRequest.removeFilter(key);
    }

    public PageRequest addFilter(String key, Relation relation, Object ... value) {
        return this.pageRequest.addFilter(key, relation, value);
    }

    public PageRequest addFilter(String key, Object ... value) {
        return this.pageRequest.addFilter(key, value);
    }

    public PageRequest andFilter(Filter ... filters) {
        return this.pageRequest.andFilter(filters);
    }

    public PageRequest orFilters(Filter ... filters) {
        return this.pageRequest.orFilters(filters);
    }

    private String decode(String value) {
        return new String(Base64.getDecoder().decode(value));
    }

    public PageRequest toPageRequest(Class<?> clazz) {
        String filter;
        this.pageRequest.setCurrent(this.current);
        this.pageRequest.setPageSize(this.pageSize);
        ClassContent content = new ClassContent(clazz, this.pageRequest);
        String sort = this.request.getParameter("sort");
        if (StringUtils.hasLength((String)sort) && JSON.isValid((String)(sort = this.decode(sort)))) {
            this.removeKeys.add("sort");
            JSONObject jsonObject = JSON.parseObject((String)sort);
            for (String key2 : jsonObject.keySet()) {
                String value = jsonObject.getString(key2);
                if ("ascend".equals(value)) {
                    this.pageRequest.addSort(Sort.by((String[])new String[]{key2}).ascending());
                    continue;
                }
                this.pageRequest.addSort(Sort.by((String[])new String[]{key2}).descending());
            }
        }
        if (StringUtils.hasLength((String)(filter = this.request.getParameter("filter"))) && JSON.isValid((String)(filter = this.decode(filter)))) {
            this.removeKeys.add("filter");
            JSONObject jsonObject = JSON.parseObject((String)filter);
            for (String key3 : jsonObject.keySet()) {
                JSONArray value = jsonObject.getJSONArray(key3);
                if (value == null || value.isEmpty()) continue;
                List<String> values = value.stream().map(Object::toString).toList();
                content.addFilter(key3, values);
            }
        }
        this.request.getParameterNames().asIterator().forEachRemaining(key -> {
            String value;
            if (!this.removeKeys.contains(key) && StringUtils.hasLength((String)(value = this.request.getParameter(key)))) {
                content.addFilter((String)key, value);
            }
        });
        return this.pageRequest;
    }

    static class ClassContent {
        private final Class<?> clazz;
        private final PageRequest pageRequest;

        public ClassContent(Class<?> clazz, PageRequest pageRequest) {
            this.clazz = clazz;
            this.pageRequest = pageRequest;
        }

        public void addFilter(String key, String value) {
            Class<?> keyClass = this.getKeyType(key);
            Object v = this.parseObject(value, keyClass);
            this.pageRequest.addFilter(key, Relation.EQUAL, v);
        }

        private Object parseObject(String value, Class<?> keyClass) {
            if (value.getClass().equals(keyClass)) {
                return value;
            }
            return JSON.parseObject((String)value, keyClass);
        }

        public void addFilter(String key, List<String> value) {
            Class<?> keyClass = this.getKeyType(key);
            this.pageRequest.addFilter(key, Relation.IN, value.stream().map(v -> this.parseObject((String)v, keyClass)).toArray());
        }

        private Class<?> getKeyType(String key) {
            String[] keys = key.split("\\.");
            Class<?> keyClass = this.clazz;
            block0: for (String k : keys) {
                Field[] fields;
                for (Field field : fields = keyClass.getDeclaredFields()) {
                    if (!field.getName().equals(k)) continue;
                    keyClass = field.getType();
                    continue block0;
                }
            }
            return keyClass;
        }
    }
}

