/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.boot;

import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;

public class DynamicApplication {
    private static final DynamicApplication instance = new DynamicApplication();
    private ConfigurableApplicationContext context;
    private String[] runArgs;
    private Class<?> applicationClass;
    private String jarsFolder = "./jars";

    public static DynamicApplication getInstance() {
        return instance;
    }

    private DynamicApplication() {
    }

    public void run0(Class<?> applicationClass, String[] args) {
        this.runArgs = args;
        this.applicationClass = applicationClass;
        this.context = SpringApplication.run(applicationClass, (String[])args);
    }

    public static void run(Class<?> applicationClass, String[] args) {
        DynamicApplication.getInstance().addDynamicJars();
        DynamicApplication.getInstance().run0(applicationClass, args);
    }

    public static void restart() {
        DynamicApplication.getInstance().restart0();
    }

    public void restart0() {
        Thread thread = new Thread(() -> {
            this.context.close();
            this.addDynamicJars();
            this.run0(this.applicationClass, this.runArgs);
        });
        thread.setDaemon(false);
        thread.start();
    }

    private void addDynamicJars() {
        Path libsPath = Paths.get(this.jarsFolder, new String[0]);
        if (Files.exists(libsPath, new LinkOption[0]) && Files.isDirectory(libsPath, new LinkOption[0])) {
            System.out.println("Start Load Dynamic Jars:");
            ArrayList jarUrls = new ArrayList();
            try (Stream<Path> stream2 = Files.list(libsPath);){
                stream2.filter(file -> file.toString().endsWith(".jar")).map(Path::toUri).forEach(uri -> {
                    try {
                        jarUrls.add(uri.toURL());
                        System.out.println(uri);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            catch (Exception stream2) {
                // empty catch block
            }
            URL[] urls = jarUrls.toArray(new URL[0]);
            URLClassLoader urlClassLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
            Thread.currentThread().setContextClassLoader(urlClassLoader);
        }
    }

    @Generated
    public void setJarsFolder(String jarsFolder) {
        this.jarsFolder = jarsFolder;
    }
}

