/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.handler;

import com.codingapi.springboot.framework.event.DomainEvent;
import com.codingapi.springboot.framework.handler.ApplicationHandlerUtils;
import com.codingapi.springboot.framework.handler.IHandler;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class SpringEventHandler
implements ApplicationListener<DomainEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringEventHandler.class);
    public static final String THREAD_KEY = "Handler.ThreadPools";
    private final ExecutorService executorService = Executors.newFixedThreadPool(Integer.parseInt(System.getProperty("Handler.ThreadPools", "10")));

    public SpringEventHandler(List<IHandler> handlers) {
        ApplicationHandlerUtils.getInstance().addHandlers(handlers);
    }

    public void onApplicationEvent(DomainEvent domainEvent) {
        if (domainEvent.isSync()) {
            ApplicationHandlerUtils.getInstance().handler(domainEvent.getEvent());
        } else {
            this.executorService.execute(() -> ApplicationHandlerUtils.getInstance().handler(domainEvent.getEvent()));
        }
    }
}

