/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.domain.proxy;

import com.codingapi.springboot.framework.domain.event.DomainChangeEvent;
import com.codingapi.springboot.framework.event.EventPusher;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class DomainChangeInterceptor
implements MethodInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DomainChangeInterceptor.class);
    private final Class<?> targetClass;
    private final Class<?>[] parameterTypes;
    private final Object[] args;
    private final Object target;
    private final PropertyDescriptor[] propertyDescriptors;
    private final Map<String, Object> fields;

    public DomainChangeInterceptor(Class<?> targetClass, Object ... args) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        this.targetClass = targetClass;
        this.args = args;
        this.parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.parameterTypes[i] = args[i].getClass();
        }
        this.target = targetClass.getConstructor(this.parameterTypes).newInstance(args);
        this.propertyDescriptors = BeanUtils.getPropertyDescriptors(targetClass);
        this.fields = new HashMap<String, Object>();
    }

    public Object createProxy() {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(this.targetClass);
        enhancer.setCallback((Callback)this);
        return enhancer.create((Class[])this.parameterTypes, this.args);
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (method.getParameterCount() <= 0) {
            return method.invoke(this.target, args);
        }
        if (this.fields.isEmpty()) {
            this.readFields(this.fields, this.target, this.propertyDescriptors);
        }
        Object result = method.invoke(this.target, args);
        this.compareAndUpdateField();
        return result;
    }

    private void readFields(Map<String, Object> fields, Object target, PropertyDescriptor[] propertyDescriptors) throws InvocationTargetException, IllegalAccessException {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            String name = propertyDescriptor.getName();
            Object value = propertyDescriptor.getReadMethod().invoke(target, new Object[0]);
            if (this.isPrimitive(value)) {
                fields.put(name, value);
                continue;
            }
            HashMap<String, Object> childFields = new HashMap<String, Object>();
            this.readFields(childFields, value, BeanUtils.getPropertyDescriptors(value.getClass()));
            fields.put(name, childFields);
        }
    }

    private boolean isPrimitive(Object obj) {
        return obj instanceof String || obj instanceof Integer || obj instanceof Long || obj instanceof Double || obj instanceof Float || obj instanceof Boolean || obj instanceof Short || obj instanceof Byte || obj instanceof Character || obj instanceof Enum || obj instanceof Class;
    }

    private void compareAndUpdateField() throws InvocationTargetException, IllegalAccessException {
        for (PropertyDescriptor propertyDescriptor : this.propertyDescriptors) {
            String name = propertyDescriptor.getName();
            Object newValue = propertyDescriptor.getReadMethod().invoke(this.target, new Object[0]);
            Object oldValue = this.fields.get(name);
            if (this.isPrimitive(newValue)) {
                if (!newValue.equals(oldValue)) {
                    this.pushEvent(name, oldValue, newValue);
                }
                this.fields.put(name, newValue);
                continue;
            }
            HashMap<String, Object> newFields = new HashMap<String, Object>();
            this.readFields(newFields, newValue, BeanUtils.getPropertyDescriptors(newValue.getClass()));
            Map oldFields = (Map)oldValue;
            for (String key : oldFields.keySet()) {
                Object newChildValue;
                Object oldChildValue = oldFields.get(key);
                if (oldChildValue.equals(newChildValue = newFields.get(key))) continue;
                String namePrefix = name + ".";
                this.pushEvent(namePrefix + key, oldChildValue, newChildValue);
            }
            this.fields.put(name, newFields);
        }
    }

    private void pushEvent(String fieldName, Object oldValue, Object newValue) {
        EventPusher.push(new DomainChangeEvent(this.target, fieldName, oldValue, newValue));
    }
}

