/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.dto.response;

import com.codingapi.springboot.framework.dto.response.Response;
import java.util.Collection;
import lombok.Generated;
import org.springframework.data.domain.Page;

public class MultiResponse<T>
extends Response {
    private Content<T> data = new Content();

    public static <T> MultiResponse<T> of(Collection<T> data, long total) {
        MultiResponse<T> multiResponse = new MultiResponse<T>();
        multiResponse.setSuccess(true);
        multiResponse.getData().setTotal(total);
        multiResponse.getData().setList(data);
        return multiResponse;
    }

    public static <T> MultiResponse<T> of(Page<T> page) {
        return MultiResponse.of(page.getContent(), page.getTotalElements());
    }

    public static <T> MultiResponse<T> empty() {
        MultiResponse<T> multiResponse = new MultiResponse<T>();
        multiResponse.setSuccess(true);
        return multiResponse;
    }

    public static <T> MultiResponse<T> of(Collection<T> data) {
        MultiResponse<T> multiResponse = new MultiResponse<T>();
        multiResponse.setSuccess(true);
        long total = 0L;
        if (data != null) {
            total = data.size();
        }
        multiResponse.getData().setTotal(total);
        multiResponse.getData().setList(data);
        return multiResponse;
    }

    @Generated
    public void setData(Content<T> data) {
        this.data = data;
    }

    @Generated
    public Content<T> getData() {
        return this.data;
    }

    public static class Content<T> {
        private long total;
        private Collection<T> list;

        @Generated
        public void setTotal(long total) {
            this.total = total;
        }

        @Generated
        public void setList(Collection<T> list) {
            this.list = list;
        }

        @Generated
        public long getTotal() {
            return this.total;
        }

        @Generated
        public Collection<T> getList() {
            return this.list;
        }
    }
}

