/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.servlet;

import com.codingapi.springboot.framework.exception.LocaleMessageException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

@Configuration
@ConditionalOnClass(name={"org.springframework.web.servlet.HandlerExceptionResolver"})
public class BasicHandlerExceptionResolverConfiguration {
    @Bean
    public HandlerExceptionResolver servletExceptionHandler() {
        return new ServletExceptionHandler();
    }

    public static class ServletExceptionHandler
    implements HandlerExceptionResolver {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(ServletExceptionHandler.class);
        private static final String DEFAULT_ERROR_CODE = "system.err";

        public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
            MappingJackson2JsonView view = new MappingJackson2JsonView();
            ModelAndView mv = new ModelAndView((View)view);
            mv.addObject("success", (Object)false);
            if (ex instanceof LocaleMessageException) {
                LocaleMessageException localMessageException = (LocaleMessageException)ex;
                mv.addObject("errCode", (Object)localMessageException.getErrCode());
                mv.addObject("errMessage", (Object)localMessageException.getMessage());
                log.warn("controller errCode:{} exception:{}", (Object)localMessageException.getErrCode(), (Object)ex.getLocalizedMessage());
                return mv;
            }
            log.warn("controller exception:{}", (Object)ex.getLocalizedMessage(), (Object)ex);
            mv.addObject("errCode", (Object)DEFAULT_ERROR_CODE);
            mv.addObject("errMessage", (Object)ex.getMessage());
            return mv;
        }
    }
}

