/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.datasource.relational;

import com.codingapi.tx.aop.bean.TxTransactionLocal;
import com.codingapi.tx.datasource.ICallClose;
import com.codingapi.tx.datasource.ILCNResource;
import com.codingapi.tx.datasource.service.DataSourceService;
import com.codingapi.tx.framework.task.TaskGroup;
import com.codingapi.tx.framework.task.TaskGroupManager;
import com.codingapi.tx.framework.task.TxTask;
import com.codingapi.tx.framework.thread.HookRunnable;
import com.lorne.core.framework.utils.task.Task;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LCNDBConnection
implements Connection,
ILCNResource<Connection> {
    private Logger logger = LoggerFactory.getLogger(LCNDBConnection.class);
    private volatile int state = 0;
    private Connection connection;
    private DataSourceService dataSourceService;
    private ICallClose<LCNDBConnection> runnable;
    private int maxOutTime;
    private boolean hasGroup = false;
    private String groupId;
    private boolean readOnly;
    private TxTask waitTask;
    private boolean hasClose = false;

    public LCNDBConnection(Connection connection, DataSourceService dataSourceService, TxTransactionLocal transactionLocal, ICallClose<LCNDBConnection> runnable) {
        this.connection = connection;
        this.runnable = runnable;
        this.dataSourceService = dataSourceService;
        this.groupId = transactionLocal.getGroupId();
        this.maxOutTime = transactionLocal.getMaxTimeOut();
        TaskGroup taskGroup = TaskGroupManager.getInstance().createTask(transactionLocal.getKid(), transactionLocal.getType());
        this.waitTask = taskGroup.getCurrent();
        this.logger.info("task-create-> " + this.waitTask.getKey());
    }

    public void setHasIsGroup(boolean isGroup) {
        this.hasGroup = isGroup;
    }

    public int getMaxOutTime() {
        return this.maxOutTime;
    }

    public Connection get() {
        return this.connection;
    }

    @Override
    public void commit() throws SQLException {
        if (this.readOnly) {
            this.connection.commit();
            return;
        }
        this.logger.info("commit");
        this.state = 1;
        this.close();
        this.hasClose = true;
    }

    @Override
    public void rollback() throws SQLException {
        if (this.readOnly) {
            this.connection.rollback();
            return;
        }
        this.logger.info("rollback");
        this.state = 0;
        this.close();
        this.hasClose = true;
    }

    protected void closeConnection() throws SQLException {
        this.runnable.close((Object)this);
        this.connection.close();
        this.logger.info("close-connection->" + this.groupId);
    }

    @Override
    public void close() throws SQLException {
        if (this.readOnly) {
            this.connection.close();
            return;
        }
        if (this.hasClose) {
            this.hasClose = false;
            return;
        }
        this.logger.info("close-state->" + this.state + "," + this.groupId);
        if (this.state == 0) {
            if (this.waitTask != null && this.waitTask.isAwait() && !this.waitTask.isRemove()) {
                this.waitTask.setState(0);
                this.waitTask.signalTask();
            } else {
                this.connection.rollback();
                this.closeConnection();
            }
            this.logger.info("rollback->" + this.groupId);
        }
        if (this.state == 1) {
            if (this.hasGroup) {
                return;
            }
            HookRunnable runnable = new HookRunnable(){

                public void run0() {
                    try {
                        LCNDBConnection.this.transaction();
                    }
                    catch (Exception e) {
                        try {
                            LCNDBConnection.this.connection.rollback();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                    finally {
                        try {
                            LCNDBConnection.this.closeConnection();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            Thread thread = new Thread((Runnable)runnable);
            thread.start();
        }
    }

    public void transaction() throws SQLException {
        if (this.waitTask == null) {
            this.connection.rollback();
            System.out.println("waitTask is null");
            return;
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                System.out.println("\u81ea\u52a8\u56de\u6eda->" + LCNDBConnection.this.getGroupId());
                LCNDBConnection.this.dataSourceService.schedule(LCNDBConnection.this.getGroupId(), (Task)LCNDBConnection.this.waitTask);
            }
        }, this.getMaxOutTime());
        System.out.println("transaction-awaitTask->" + this.getGroupId());
        this.waitTask.awaitTask();
        timer.cancel();
        int rs = this.waitTask.getState();
        System.out.println("(" + this.getGroupId() + ")->\u5355\u5143\u4e8b\u52a1\uff081\uff1a\u63d0\u4ea4 0\uff1a\u56de\u6eda -1\uff1a\u4e8b\u52a1\u6a21\u5757\u7f51\u7edc\u5f02\u5e38\u56de\u6eda -2\uff1a\u4e8b\u52a1\u6a21\u5757\u8d85\u65f6\u5f02\u5e38\u56de\u6eda\uff09:" + rs);
        if (rs == 1) {
            this.connection.commit();
        } else {
            this.connection.rollback();
        }
        this.waitTask.remove();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public TxTask getWaitTask() {
        return this.waitTask;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(false);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.connection.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.connection.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.connection.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.connection.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.connection.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.connection.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.connection.prepareStatement(sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.connection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.connection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.connection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.connection.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.connection.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.connection.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.connection.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connection.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.connection.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.connection.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.connection.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.connection.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.connection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.connection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.connection.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.connection.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.connection.isWrapperFor(iface);
    }
}

