/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.datasource.relational;

import com.codingapi.tx.aop.bean.TxTransactionLocal;
import com.codingapi.tx.datasource.AbstractResourceProxy;
import com.codingapi.tx.datasource.ICallClose;
import com.codingapi.tx.datasource.relational.LCNDBConnection;
import com.codingapi.tx.datasource.relational.LCNRollBackDBConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LCNTransactionDataSource
extends AbstractResourceProxy<Connection, LCNDBConnection>
implements DataSource {
    private Logger logger = LoggerFactory.getLogger(LCNTransactionDataSource.class);
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected Connection createLcnConnection(Connection connection, TxTransactionLocal txTransactionLocal) {
        ++this.nowCount;
        LCNDBConnection lcn = new LCNDBConnection(connection, this.dataSourceService, txTransactionLocal, (ICallClose<LCNDBConnection>)this.subNowCount);
        this.pools.put(txTransactionLocal.getGroupId(), lcn);
        this.logger.info("get new connection ->" + txTransactionLocal.getGroupId());
        return lcn;
    }

    protected Connection getRollback(Connection connection) {
        LCNRollBackDBConnection rollBackDBConnection = new LCNRollBackDBConnection(connection);
        return rollBackDBConnection;
    }

    protected void initDbType() {
        TxTransactionLocal txTransactionLocal = TxTransactionLocal.current();
        if (txTransactionLocal != null) {
            txTransactionLocal.setType("datasource");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.initDbType();
        Connection connection = (Connection)this.loadConnection();
        if (connection == null) {
            connection = (Connection)this.initLCNConnection(this.dataSource.getConnection());
            if (connection == null) {
                throw new SQLException("connection was overload");
            }
            return connection;
        }
        return connection;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.initDbType();
        Connection connection = (Connection)this.loadConnection();
        if (connection == null) {
            return (Connection)this.initLCNConnection(this.dataSource.getConnection(username, password));
        }
        return connection;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }
}

