/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.datasource.relational;

import com.codingapi.tx.framework.thread.HookRunnable;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransactionThread {
    private volatile boolean hasStartTransaction = false;
    private Logger logger = LoggerFactory.getLogger(AbstractTransactionThread.class);

    protected void startRunnable() {
        if (this.hasStartTransaction) {
            this.logger.info("start connection is wait ! ");
            return;
        }
        this.hasStartTransaction = true;
        HookRunnable runnable = new HookRunnable(){

            public void run0() {
                try {
                    AbstractTransactionThread.this.transaction();
                }
                catch (Exception e) {
                    AbstractTransactionThread.this.logger.error(e.getMessage());
                    try {
                        AbstractTransactionThread.this.rollbackConnection();
                    }
                    catch (SQLException e1) {
                        AbstractTransactionThread.this.logger.error(e1.getMessage());
                    }
                }
                finally {
                    try {
                        AbstractTransactionThread.this.closeConnection();
                    }
                    catch (SQLException e) {
                        AbstractTransactionThread.this.logger.error(e.getMessage());
                    }
                }
            }
        };
        Thread thread = new Thread((Runnable)runnable);
        thread.start();
    }

    protected abstract void transaction() throws SQLException;

    protected abstract void closeConnection() throws SQLException;

    protected abstract void rollbackConnection() throws SQLException;
}

