/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.datasource.relational;

import com.codingapi.tx.aop.bean.TxTransactionLocal;
import com.codingapi.tx.datasource.ICallClose;
import com.codingapi.tx.datasource.ILCNResource;
import com.codingapi.tx.datasource.bean.LCNDataSourceLocal;
import com.codingapi.tx.datasource.relational.LCNDBConnection;
import com.codingapi.tx.datasource.relational.LCNStartConnection;
import com.codingapi.tx.datasource.relational.LCNTransactionDataSource;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LCNDynamicTransactionDataSource
extends LCNTransactionDataSource {
    private Logger logger = LoggerFactory.getLogger(LCNDynamicTransactionDataSource.class);
    private Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();

    private String getNowDataSourceKey() {
        if (LCNDataSourceLocal.current() == null) {
            return "default";
        }
        return LCNDataSourceLocal.current().getKey();
    }

    public boolean hasGroup(String group) {
        return super.hasGroup(this.getNowDataSourceKey() + group);
    }

    @Override
    protected Connection createLcnConnection(Connection connection, TxTransactionLocal txTransactionLocal) {
        ++this.nowCount;
        if (txTransactionLocal.isHasStart()) {
            LCNStartConnection lcnStartConnection = new LCNStartConnection(connection, (ICallClose<ILCNResource>)this.subNowCount);
            this.logger.info("get new start connection - > " + txTransactionLocal.getGroupId());
            this.pools.put(this.getNowDataSourceKey() + txTransactionLocal.getGroupId(), lcnStartConnection);
            txTransactionLocal.setHasConnection(true);
            return lcnStartConnection;
        }
        LCNDBConnection lcn = new LCNDBConnection(connection, this.dataSourceService, (ICallClose<ILCNResource>)this.subNowCount);
        this.logger.info("get new connection ->" + txTransactionLocal.getGroupId());
        this.pools.put(this.getNowDataSourceKey() + txTransactionLocal.getGroupId(), lcn);
        txTransactionLocal.setHasConnection(true);
        return lcn;
    }

    public void addDataSource(String key, DataSource dataSource) {
        this.dataSourceMap.put(key, dataSource);
        this.logger.info("add datasource of " + key);
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        this.addDataSource("default", dataSource);
        this.logger.info("load default datasource.");
    }

    @Override
    protected DataSource getDataSource() {
        this.logger.info("getDataSource--->");
        if (LCNDataSourceLocal.current() == null) {
            return super.getDataSource();
        }
        String key = LCNDataSourceLocal.current().getKey();
        this.logger.info("get datasource of " + key);
        return this.dataSourceMap.get(key);
    }
}

