/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.datasource.relational;

import com.codingapi.tx.aop.bean.TxCompensateLocal;
import com.codingapi.tx.aop.bean.TxTransactionLocal;
import com.codingapi.tx.datasource.ICallClose;
import com.codingapi.tx.datasource.ILCNResource;
import com.codingapi.tx.datasource.relational.AbstractTransactionThread;
import com.codingapi.tx.datasource.relational.LCNConnection;
import com.codingapi.tx.framework.task.TaskGroup;
import com.codingapi.tx.framework.task.TaskGroupManager;
import com.codingapi.tx.framework.task.TaskState;
import com.codingapi.tx.framework.task.TxTask;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LCNStartConnection
extends AbstractTransactionThread
implements LCNConnection {
    private Logger logger = LoggerFactory.getLogger(LCNStartConnection.class);
    private Connection connection;
    private ICallClose<ILCNResource> subNowCount;
    private String groupId;
    private TxTask waitTask;
    private volatile int state = 1;
    private boolean isCompensate = false;
    private int startState = 0;
    private ThreadLocal<Boolean> isClose = new ThreadLocal();

    public LCNStartConnection(Connection connection, ICallClose<ILCNResource> subNowCount) {
        this.connection = connection;
        this.subNowCount = subNowCount;
        if (TxCompensateLocal.current() != null) {
            this.isCompensate = true;
            this.logger.info("transaction is compensate-connection.");
            TxCompensateLocal txCompensateLocal = TxCompensateLocal.current();
            this.groupId = txCompensateLocal.getGroupId();
            TaskGroup taskGroup = TaskGroupManager.getInstance().createTask(this.groupId, txCompensateLocal.getType());
            this.waitTask = taskGroup.getCurrent();
            this.startState = txCompensateLocal.getStartState();
        } else {
            this.isCompensate = false;
            this.logger.info("transaction is start-connection.");
            TxTransactionLocal txTransactionLocal = TxTransactionLocal.current();
            this.groupId = txTransactionLocal.getGroupId();
            TaskGroup taskGroup = TaskGroupManager.getInstance().createTask(this.groupId, txTransactionLocal.getType());
            this.waitTask = taskGroup.getCurrent();
        }
        this.logger.info("lcn start connection init ok .");
    }

    public TxTask getWaitTask() {
        return this.waitTask;
    }

    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void commit() throws SQLException {
        this.logger.info("commit label");
        this.state = 1;
        this.close();
        this.isClose.set(true);
    }

    @Override
    public void rollback() throws SQLException {
        this.logger.info("rollback label");
        this.state = 0;
        this.close();
        this.isClose.set(true);
    }

    @Override
    public void close() throws SQLException {
        if (this.isClose.get() != null && this.isClose.get().booleanValue()) {
            return;
        }
        if (this.connection == null || this.connection.isClosed()) {
            return;
        }
        if (this.state == 0) {
            this.rollbackConnection();
            this.closeConnection();
            return;
        }
        if (this.state == 1) {
            boolean isGroup;
            TxTransactionLocal txTransactionLocal = TxTransactionLocal.current();
            boolean bl = isGroup = txTransactionLocal != null ? txTransactionLocal.isHasIsGroup() : false;
            if (isGroup) {
                this.logger.info("start connection hasGroup -> " + isGroup);
                return;
            }
            this.startRunnable();
        }
    }

    @Override
    protected void rollbackConnection() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public void transaction() throws SQLException {
        if (this.waitTask == null) {
            this.rollbackConnection();
            System.out.println(" start waitTask is null");
            return;
        }
        System.out.println(" start transaction is wait for TxManager notify, groupId : " + this.getGroupId());
        this.waitTask.awaitTask();
        int rs = this.waitTask.getState();
        try {
            if (rs == 1) {
                if (this.isCompensate) {
                    rs = this.startState;
                    if (rs == 1) {
                        this.connection.commit();
                    } else {
                        this.connection.rollback();
                    }
                } else {
                    this.connection.commit();
                }
            } else {
                this.rollbackConnection();
            }
            System.out.println(" lcn start transaction over, res -> groupId:" + this.getGroupId() + " and  state is " + (rs == 1 ? "commit" : "rollback"));
        }
        catch (SQLException e) {
            this.waitTask.setState(TaskState.connectionError.getCode());
            System.out.println(" lcn start transaction over,but connection is closed,  res -> groupId:" + this.getGroupId());
        }
        this.waitTask.remove();
    }

    @Override
    protected void closeConnection() throws SQLException {
        this.subNowCount.close((Object)this);
        this.connection.close();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.connection != null) {
            this.connection.setAutoCommit(false);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.connection.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.connection.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.connection.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.connection.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.connection.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.connection.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.connection.prepareStatement(sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.connection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.connection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.connection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.connection.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.connection.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.connection.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.connection.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connection.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.connection.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.connection.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.connection.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.connection.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.connection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.connection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.connection.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.connection.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.connection.isWrapperFor(iface);
    }
}

