/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.datasource.relational;

import com.codingapi.tx.aop.bean.TxCompensateLocal;
import com.codingapi.tx.aop.bean.TxTransactionLocal;
import com.codingapi.tx.datasource.AbstractResourceProxy;
import com.codingapi.tx.datasource.ICallClose;
import com.codingapi.tx.datasource.ILCNResource;
import com.codingapi.tx.datasource.relational.LCNDBConnection;
import com.codingapi.tx.datasource.relational.LCNStartConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LCNTransactionDataSource
extends AbstractResourceProxy<Connection, LCNDBConnection>
implements DataSource {
    private Logger logger = LoggerFactory.getLogger(LCNTransactionDataSource.class);
    protected DataSource dataSource;

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected Connection createLcnConnection(Connection connection, TxTransactionLocal txTransactionLocal) {
        ++this.nowCount;
        if (txTransactionLocal.isHasStart()) {
            LCNStartConnection lcnStartConnection = new LCNStartConnection(connection, (ICallClose<ILCNResource>)this.subNowCount);
            this.logger.info("get new start connection - > " + txTransactionLocal.getGroupId());
            this.pools.put(txTransactionLocal.getGroupId(), lcnStartConnection);
            txTransactionLocal.setHasConnection(true);
            return lcnStartConnection;
        }
        LCNDBConnection lcn = new LCNDBConnection(connection, this.dataSourceService, (ICallClose<ILCNResource>)this.subNowCount);
        this.logger.info("get new connection ->" + txTransactionLocal.getGroupId());
        this.pools.put(txTransactionLocal.getGroupId(), lcn);
        txTransactionLocal.setHasConnection(true);
        return lcn;
    }

    protected void initDbType() {
        TxCompensateLocal txCompensateLocal;
        TxTransactionLocal txTransactionLocal = TxTransactionLocal.current();
        if (txTransactionLocal != null) {
            txTransactionLocal.setType("datasource");
        }
        if ((txCompensateLocal = TxCompensateLocal.current()) != null) {
            txCompensateLocal.setType("datasource");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.initDbType();
        Connection connection = (Connection)this.loadConnection();
        if (connection == null) {
            connection = (Connection)this.initLCNConnection(this.getDataSource().getConnection());
            if (connection == null) {
                throw new SQLException("connection was overload");
            }
            return connection;
        }
        return connection;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.initDbType();
        Connection connection = (Connection)this.loadConnection();
        if (connection == null) {
            connection = (Connection)this.initLCNConnection(this.getDataSource().getConnection(username, password));
            if (connection == null) {
                throw new SQLException("connection was overload");
            }
            return connection;
        }
        return connection;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getDataSource().setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getDataSource().setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getDataSource().getLoginTimeout();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.getDataSource().getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getDataSource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getDataSource().isWrapperFor(iface);
    }
}

