/*
 * Decompiled with CFR 0.152.
 */
package cn.kdan.compdfkit.client;

import cn.kdan.compdfkit.exception.ComPDFKitException;
import cn.kdan.compdfkit.param.CFileParameter;
import cn.kdan.compdfkit.pojo.comPdfKit.CCreateTaskResult;
import cn.kdan.compdfkit.pojo.comPdfKit.CFileInfo;
import cn.kdan.compdfkit.pojo.comPdfKit.CTaskInfoResult;
import cn.kdan.compdfkit.pojo.comPdfKit.CTaskRecordsResult;
import cn.kdan.compdfkit.pojo.comPdfKit.CTenantAssetResult;
import cn.kdan.compdfkit.pojo.comPdfKit.CTool;
import cn.kdan.compdfkit.pojo.comPdfKit.CUploadFileResult;
import cn.kdan.compdfkit.pojo.comPdfKit.ComPdfKitOauthResult;
import cn.kdan.compdfkit.pojo.comPdfKit.ComPdfKitResult;
import cn.kdan.compdfkit.utils.CJsonUtils;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class CHttpClient {
    private final RestTemplate restTemplate;
    private final Logger log = LoggerFactory.getLogger(CHttpClient.class);
    private final String address;
    private long expireTime;
    private static String accessToken;
    private final String publicKey;
    private final String secretKey;

    CHttpClient(RestTemplate restTemplate, String publicKey, String secretKey) {
        this.address = "https://api-server.compdf.com/server/";
        this.restTemplate = restTemplate;
        this.publicKey = publicKey;
        this.secretKey = secretKey;
        this.refreshAccessToken();
    }

    private HttpHeaders basicHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + this.getAccessToken());
        return headers;
    }

    String getAccessToken() {
        if (ObjectUtils.isEmpty((Object)this.expireTime) || System.currentTimeMillis() > this.expireTime) {
            this.refreshAccessToken();
        }
        return accessToken;
    }

    void setAccessToken(String token, long expiresIn) {
        accessToken = token;
        this.expireTime = System.currentTimeMillis() + expiresIn * 1000L;
    }

    void refreshAccessToken() {
        ComPdfKitOauthResult newToken = this.getComPdfKitAuth(this.publicKey, this.secretKey);
        this.setAccessToken(newToken.getAccessToken(), Long.parseLong(newToken.getExpiresIn()));
    }

    ComPdfKitOauthResult getComPdfKitAuth(String publicKey, String secretKey) {
        ResponseEntity responseEntity;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> tokenParam = new HashMap<String, String>();
        tokenParam.put("publicKey", publicKey);
        tokenParam.put("secretKey", secretKey);
        ParameterizedTypeReference<ComPdfKitResult<ComPdfKitOauthResult>> typeRef = new ParameterizedTypeReference<ComPdfKitResult<ComPdfKitOauthResult>>(){};
        try {
            responseEntity = this.restTemplate.exchange(this.address.concat("v1/oauth/token"), HttpMethod.POST, new HttpEntity((Object)CJsonUtils.getJsonString(tokenParam), (MultiValueMap)headers), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Failed to get ComPDFKit Token: {}", (Object)e.getMessage());
            throw new ComPDFKitException("Failed to get ComPDFKit Token: ");
        }
        if (responseEntity.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)responseEntity.getBody()) || !((ComPdfKitResult)responseEntity.getBody()).getCode().equals("200")) {
            throw new ComPDFKitException(((ComPdfKitResult)Objects.requireNonNull(responseEntity.getBody())).getCode(), ((ComPdfKitResult)responseEntity.getBody()).getMsg());
        }
        return (ComPdfKitOauthResult)((ComPdfKitResult)responseEntity.getBody()).getData();
    }

    List<CTool> getTools() {
        ResponseEntity response;
        String url = this.address.concat("v1/tool/support");
        ParameterizedTypeReference<ComPdfKitResult<List<CTool>>> typeRef = new ParameterizedTypeReference<ComPdfKitResult<List<CTool>>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas query tools  failed: {}", (Object)e.getMessage());
            throw new ComPDFKitException("Saas query tools  failed: " + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((ComPdfKitResult)response.getBody()).getCode().equals("200")) {
            throw new ComPDFKitException(((ComPdfKitResult)Objects.requireNonNull(response.getBody())).getCode(), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        return (List)((ComPdfKitResult)response.getBody()).getData();
    }

    CFileInfo getFileInfo(String fileKey) {
        ResponseEntity response;
        String url = this.address.concat("v1/file/fileInfo").concat("?fileKey=").concat(fileKey);
        ParameterizedTypeReference<ComPdfKitResult<CFileInfo>> typeRef = new ParameterizedTypeReference<ComPdfKitResult<CFileInfo>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas query file info failed: {}", (Object)e.getMessage());
            throw new ComPDFKitException("Saas query file info failed: " + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((ComPdfKitResult)response.getBody()).getCode().equals("200")) {
            throw new ComPDFKitException(((ComPdfKitResult)Objects.requireNonNull(response.getBody())).getCode(), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        return (CFileInfo)((ComPdfKitResult)response.getBody()).getData();
    }

    CTenantAssetResult getAssetInfo() {
        ResponseEntity response;
        String url = this.address.concat("v1/asset/info");
        ParameterizedTypeReference<ComPdfKitResult<CTenantAssetResult>> typeRef = new ParameterizedTypeReference<ComPdfKitResult<CTenantAssetResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas query tenant asset failed: {}", (Object)e.getMessage());
            throw new ComPDFKitException("Saas query tenant asset failed: " + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((ComPdfKitResult)response.getBody()).getCode().equals("200")) {
            throw new ComPDFKitException(((ComPdfKitResult)Objects.requireNonNull(response.getBody())).getCode(), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        return (CTenantAssetResult)((ComPdfKitResult)response.getBody()).getData();
    }

    CTaskRecordsResult getTaskList(String page, String size) {
        ResponseEntity response;
        if (StringUtils.isEmpty((Object)page)) {
            page = "1";
        }
        if (StringUtils.isEmpty((Object)size)) {
            size = "5";
        }
        String url = this.address.concat("v1/task/list").concat("?page=").concat(page).concat("&size=").concat(size);
        ParameterizedTypeReference<ComPdfKitResult<CTaskRecordsResult>> typeRef = new ParameterizedTypeReference<ComPdfKitResult<CTaskRecordsResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("{}", (Object)e.getMessage());
            throw new ComPDFKitException("" + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((ComPdfKitResult)response.getBody()).getCode().equals("200")) {
            throw new ComPDFKitException(((ComPdfKitResult)Objects.requireNonNull(response.getBody())).getCode(), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        return (CTaskRecordsResult)((ComPdfKitResult)response.getBody()).getData();
    }

    CCreateTaskResult createTask(String executeTypeUrl) {
        ResponseEntity response;
        String url = this.address.concat("v1/task/{executeTypeUrl}").replace("{executeTypeUrl}", executeTypeUrl);
        ParameterizedTypeReference<ComPdfKitResult<CCreateTaskResult>> typeRef = new ParameterizedTypeReference<ComPdfKitResult<CCreateTaskResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas task creation failed: {}", (Object)e.getMessage());
            throw new ComPDFKitException("Saas task creation failed: " + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((ComPdfKitResult)response.getBody()).getCode().equals("200")) {
            throw new ComPDFKitException(((ComPdfKitResult)Objects.requireNonNull(response.getBody())).getCode(), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        return (CCreateTaskResult)((ComPdfKitResult)response.getBody()).getData();
    }

    CUploadFileResult getUploadFileResult(File file, String taskId, String password, CFileParameter fileParameter) {
        try {
            return this.getUploadFileResult(new FileInputStream(file), taskId, password, fileParameter, file.getName());
        }
        catch (FileNotFoundException e) {
            throw new ComPDFKitException(e.getMessage(), e);
        }
    }

    CUploadFileResult getUploadFileResult(final InputStream fileInputStream, String taskId, String password, CFileParameter fileParameter, final String fileName) {
        this.log.info("Start uploading files, task Id: {}, password: {}", (Object)taskId, (Object)password);
        String url = this.address.concat("v1/file/upload");
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        InputStreamResource inputStreamResource = new InputStreamResource(fileInputStream){

            public long contentLength() throws IOException {
                return fileInputStream.available();
            }

            public String getFilename() {
                return fileName;
            }
        };
        param.add((Object)"file", (Object)inputStreamResource);
        param.add((Object)"taskId", (Object)taskId);
        if (!StringUtils.isEmpty((Object)password)) {
            param.add((Object)"password", (Object)password);
        }
        if (!ObjectUtils.isEmpty((Object)fileParameter)) {
            param.add((Object)"parameter", (Object)JSON.toJSONString((Object)fileParameter));
        }
        HttpHeaders headers = this.basicHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        ResponseEntity response = null;
        ParameterizedTypeReference<ComPdfKitResult<CUploadFileResult>> typeRef = new ParameterizedTypeReference<ComPdfKitResult<CUploadFileResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)param, (MultiValueMap)headers), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas upload file failed: {}", (Object)e.getMessage());
            throw new ComPDFKitException("Saas upload file failed: " + e.getMessage());
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException e) {
                this.log.error("Failed to delete file; {}", (Object)e.getMessage());
            }
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !"200".equals(((ComPdfKitResult)response.getBody()).getCode())) {
            throw new ComPDFKitException(((ComPdfKitResult)Objects.requireNonNull(response.getBody())).getCode(), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        return (CUploadFileResult)((ComPdfKitResult)response.getBody()).getData();
    }

    CCreateTaskResult executeTask(String taskId) {
        ResponseEntity response;
        this.log.info("Start executing task transfer, taskId: {}", (Object)taskId);
        String url = this.address.concat("v1/execute/start").concat("?taskId=").concat(taskId);
        ParameterizedTypeReference<ComPdfKitResult<CCreateTaskResult>> result = new ParameterizedTypeReference<ComPdfKitResult<CCreateTaskResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((Object)CJsonUtils.getJsonString(taskId), (MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)result, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas file conversion failed: {}", (Object)e.getMessage());
            throw new ComPDFKitException("Saas file conversion failed: " + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !"200".equals(((ComPdfKitResult)response.getBody()).getCode())) {
            throw new ComPDFKitException(((ComPdfKitResult)Objects.requireNonNull(response.getBody())).getCode(), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        return (CCreateTaskResult)((ComPdfKitResult)response.getBody()).getData();
    }

    CTaskInfoResult getTaskInfo(String taskId) {
        ResponseEntity response;
        this.log.info("Start to query the transfer status, taskId: {}", (Object)taskId);
        String url = this.address.concat("v1/task/taskInfo").concat("?taskId=").concat(taskId);
        ParameterizedTypeReference<ComPdfKitResult<CTaskInfoResult>> result = new ParameterizedTypeReference<ComPdfKitResult<CTaskInfoResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((Object)CJsonUtils.getJsonString(taskId), (MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)result, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Failed to query saas file status: {}", (Object)e.getMessage());
            throw new ComPDFKitException("Failed to query saas file status: " + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !"200".equals(((ComPdfKitResult)response.getBody()).getCode())) {
            throw new ComPDFKitException(((ComPdfKitResult)Objects.requireNonNull(response.getBody())).getCode(), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        this.log.info("Query status succeeded: {}", (Object)CJsonUtils.getJsonString(((ComPdfKitResult)response.getBody()).getData()));
        return (CTaskInfoResult)((ComPdfKitResult)response.getBody()).getData();
    }
}

