/*
 * Decompiled with CFR 0.152.
 */
package cn.kdan.compdfkit.client;

import cn.kdan.compdfkit.client.CHttpClient;
import cn.kdan.compdfkit.enums.CDocumentAIEnum;
import cn.kdan.compdfkit.enums.COfficeToPDFEnum;
import cn.kdan.compdfkit.enums.CPDFServerEnum;
import cn.kdan.compdfkit.enums.CPDFToOfficeEnum;
import cn.kdan.compdfkit.param.CFileParameter;
import cn.kdan.compdfkit.pojo.comPdfKit.CCreateTaskResult;
import cn.kdan.compdfkit.pojo.comPdfKit.CFileInfo;
import cn.kdan.compdfkit.pojo.comPdfKit.CTaskInfoResult;
import cn.kdan.compdfkit.pojo.comPdfKit.CTaskRecordsResult;
import cn.kdan.compdfkit.pojo.comPdfKit.CTenantAssetResult;
import cn.kdan.compdfkit.pojo.comPdfKit.CTool;
import cn.kdan.compdfkit.pojo.comPdfKit.CUploadFileResult;
import cn.kdan.compdfkit.pojo.comPdfKit.ComPdfKitOauthResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

public class ComPDFKitClient {
    private final CHttpClient httpClient;

    public ComPDFKitClient(String publicKey, String secretKey) {
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        restTemplateBuilder.setReadTimeout(Duration.ofSeconds(300L));
        restTemplateBuilder.setConnectTimeout(Duration.ofSeconds(300L));
        restTemplateBuilder.setBufferRequestBody(false);
        RestTemplate restTemplate = restTemplateBuilder.build();
        this.httpClient = new CHttpClient(restTemplate, publicKey, secretKey);
        this.httpClient.refreshAccessToken();
    }

    public ComPDFKitClient(String publicKey, String secretKey, Long readTimeout, Long connectTimeout) {
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        restTemplateBuilder.setReadTimeout(Duration.ofSeconds(readTimeout));
        restTemplateBuilder.setConnectTimeout(Duration.ofSeconds(connectTimeout));
        restTemplateBuilder.setBufferRequestBody(false);
        RestTemplate restTemplate = restTemplateBuilder.build();
        this.httpClient = new CHttpClient(restTemplate, publicKey, secretKey);
        this.httpClient.refreshAccessToken();
    }

    private ComPdfKitOauthResult getComPdfKitAuth(String publicKey, String secretKey) {
        return this.httpClient.getComPdfKitAuth(publicKey, secretKey);
    }

    public List<CTool> getTools() {
        return this.httpClient.getTools();
    }

    public CFileInfo getFileInfo(String fileKey) {
        return this.httpClient.getFileInfo(fileKey);
    }

    public CTenantAssetResult getAssetInfo() {
        return this.httpClient.getAssetInfo();
    }

    public CTaskRecordsResult getTaskList(String page, String size) {
        return this.httpClient.getTaskList(page, size);
    }

    public CCreateTaskResult createTask(String executeTypeUrl) {
        return this.httpClient.createTask(executeTypeUrl);
    }

    public CCreateTaskResult createTask(COfficeToPDFEnum officeToPDFEnum) {
        return this.createTask(officeToPDFEnum.getValue());
    }

    public CCreateTaskResult createTask(CPDFServerEnum pdfServerEnum) {
        return this.createTask(pdfServerEnum.getValue());
    }

    public CCreateTaskResult createTask(CPDFToOfficeEnum pdfToOfficeEnum) {
        return this.createTask(pdfToOfficeEnum.getValue());
    }

    public CCreateTaskResult createTask(CDocumentAIEnum documentAIEnum) {
        return this.createTask(documentAIEnum.getValue());
    }

    public CUploadFileResult uploadFile(File file, String taskId, String password) {
        return this.getUploadFileResult(file, taskId, password, null);
    }

    public CUploadFileResult uploadFile(InputStream file, String taskId, String password, String fileName) {
        return this.getUploadFileResult(file, taskId, password, null, fileName);
    }

    public CUploadFileResult uploadFile(URL file, String taskId, String password, String fileName) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, password, null, fileName);
    }

    public CUploadFileResult uploadFile(MultipartFile file, String taskId, String password) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, password, null, file.getOriginalFilename());
    }

    public CUploadFileResult uploadFile(File file, String taskId) {
        return this.getUploadFileResult(file, taskId, null, null);
    }

    public CUploadFileResult uploadFile(InputStream file, String taskId, String fileName) {
        return this.getUploadFileResult(file, taskId, null, null, fileName);
    }

    public CUploadFileResult uploadFile(URL file, String taskId, String fileName) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, null, null, fileName);
    }

    public CUploadFileResult uploadFile(MultipartFile file, String taskId) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, null, null, file.getOriginalFilename());
    }

    public CUploadFileResult uploadFile(File file, String taskId, String password, CFileParameter fileParameter) {
        return this.getUploadFileResult(file, taskId, password, fileParameter);
    }

    public CUploadFileResult uploadFile(InputStream file, String taskId, String password, CFileParameter fileParameter, String fileName) {
        return this.getUploadFileResult(file, taskId, password, fileParameter, fileName);
    }

    public CUploadFileResult uploadFile(URL file, String taskId, String password, CFileParameter fileParameter, String fileName) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, password, fileParameter, fileName);
    }

    public CUploadFileResult uploadFile(MultipartFile file, String taskId, String password, CFileParameter fileParameter) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, password, fileParameter, file.getOriginalFilename());
    }

    public CUploadFileResult uploadFile(File file, String taskId, CFileParameter fileParameter) {
        return this.getUploadFileResult(file, taskId, null, fileParameter);
    }

    public CUploadFileResult uploadFile(InputStream file, String taskId, CFileParameter fileParameter, String fileName) {
        return this.getUploadFileResult(file, taskId, null, fileParameter, fileName);
    }

    public CUploadFileResult uploadFile(URL file, String taskId, CFileParameter fileParameter, String fileName) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, null, fileParameter, fileName);
    }

    public CUploadFileResult uploadFile(MultipartFile file, String taskId, CFileParameter fileParameter) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, null, fileParameter, file.getOriginalFilename());
    }

    private CUploadFileResult getUploadFileResult(File file, String taskId, String password, CFileParameter fileParameter) {
        return this.httpClient.getUploadFileResult(file, taskId, password, fileParameter);
    }

    private CUploadFileResult getUploadFileResult(InputStream file, String taskId, String password, CFileParameter fileParameter, String fileName) {
        return this.httpClient.getUploadFileResult(file, taskId, password, fileParameter, fileName);
    }

    public CCreateTaskResult executeTask(String taskId) {
        return this.httpClient.executeTask(taskId);
    }

    public CTaskInfoResult getTaskInfo(String taskId) {
        return this.httpClient.getTaskInfo(taskId);
    }
}

