/*
 * Decompiled with CFR 0.152.
 */
package cn.kdan.compdfkit.param;

import cn.kdan.compdfkit.enums.PDFServerEnum;
import cn.kdan.compdfkit.enums.PDFToOfficeEnum;
import cn.kdan.compdfkit.param.AddWatermarkParameter;
import cn.kdan.compdfkit.param.FileParameter;
import cn.kdan.compdfkit.param.PDFCompressParameter;
import cn.kdan.compdfkit.param.PDFToExcelParameter;
import cn.kdan.compdfkit.param.PDFToHtmlParameter;
import cn.kdan.compdfkit.param.PageDeleteParameter;
import cn.kdan.compdfkit.param.PageExtractParameter;
import cn.kdan.compdfkit.param.PageInsertParameter;
import cn.kdan.compdfkit.param.PageMergeParameter;
import cn.kdan.compdfkit.param.PageRotationParameter;
import cn.kdan.compdfkit.param.PageSplitParameter;

public class FileParameterFactory {
    public static <T extends FileParameter> T getFileParameterByType(PDFToOfficeEnum type) {
        FileParameter fileParameter;
        Class clazz;
        switch (type) {
            case PDF_TO_EXCEL: {
                clazz = PDFToExcelParameter.class;
                fileParameter = new PDFToExcelParameter();
                break;
            }
            case PDF_TO_HTML: {
                clazz = PDFToHtmlParameter.class;
                fileParameter = new PDFToHtmlParameter();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type:" + (Object)((Object)type));
            }
        }
        return (T)((FileParameter)clazz.cast(fileParameter));
    }

    public static <T extends FileParameter> T getFileParameterByType(PDFServerEnum type) {
        FileParameter fileParameter;
        Class clazz;
        switch (type) {
            case INSERT: {
                clazz = PageInsertParameter.class;
                fileParameter = new PageInsertParameter();
                break;
            }
            case SPLIT: {
                clazz = PageSplitParameter.class;
                fileParameter = new PageSplitParameter();
                break;
            }
            case MERGE: {
                clazz = PageMergeParameter.class;
                fileParameter = new PageMergeParameter();
                break;
            }
            case COMPRESS: {
                clazz = PDFCompressParameter.class;
                fileParameter = new PDFCompressParameter();
                break;
            }
            case DELETE: {
                clazz = PageDeleteParameter.class;
                fileParameter = new PageDeleteParameter();
                break;
            }
            case EXTRACT: {
                clazz = PageExtractParameter.class;
                fileParameter = new PageExtractParameter();
                break;
            }
            case ROTATION: {
                clazz = PageRotationParameter.class;
                fileParameter = new PageRotationParameter();
                break;
            }
            case ADD_WATERMARK: {
                clazz = AddWatermarkParameter.class;
                fileParameter = new AddWatermarkParameter();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type:" + (Object)((Object)type));
            }
        }
        return (T)((FileParameter)clazz.cast(fileParameter));
    }
}

