/*
 * Decompiled with CFR 0.152.
 */
package cn.kdan.compdfkit.exception;

import cn.kdan.compdfkit.exception.BackendRuntimeException;
import cn.kdan.compdfkit.pojo.ResultMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ControllerExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(ControllerExceptionHandler.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ResultMap handlerArgumentCheck(MethodArgumentNotValidException ex) {
        BindingResult bindingResult = ex.getBindingResult();
        List fieldErrorList = bindingResult.getFieldErrors();
        StringBuilder sb = new StringBuilder("Missing required parameter!");
        for (FieldError fieldError : fieldErrorList) {
            sb.append(fieldError.getField()).append(":");
            sb.append(fieldError.getDefaultMessage()).append(".");
        }
        return new ResultMap(300, sb.toString());
    }

    @ExceptionHandler(value={BackendRuntimeException.class})
    @ResponseBody
    public ResultMap handlerRuntimeException(BackendRuntimeException e) {
        this.logger.error("\u4e1a\u52a1\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        if (!ObjectUtils.isEmpty((Object)e.getCode())) {
            return new ResultMap(e.getCode(), e.getMessage());
        }
        return new ResultMap(700, e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResultMap handlerException(Exception e) {
        this.logger.info("\u9519\u8bef\u4fe1\u606f:" + e.getMessage(), (Throwable)e);
        return new ResultMap(500, "\u9519\u8bef\u4fe1\u606f\uff1a " + e.getMessage());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public ResultMap handlerMissingServletRequestParameterException(MissingServletRequestParameterException e) {
        this.logger.info(e.getMessage(), (Throwable)e);
        return new ResultMap(500, "\u53c2\u6570\u9519\u8bef\uff1a " + e.getParameterName() + " \u7f3a\u5931");
    }
}

