/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.api;

import com.contentful.java.api.ArrayParser;
import com.contentful.java.api.CDACallback;
import com.contentful.java.lib.Constants;
import com.contentful.java.model.CDAResource;
import com.contentful.java.model.CDASpace;
import com.contentful.java.model.CDASyncedSpace;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import retrofit.client.Response;

class SpaceMerger
implements Callable<CDASyncedSpace> {
    private final CDASyncedSpace originalSpace;
    private final CDASyncedSpace updatedSpace;
    private final CDACallback<CDASyncedSpace> callback;
    private final Response response;
    private final CDASpace space;

    public SpaceMerger(CDASyncedSpace originalSpace, CDASyncedSpace updatedSpace, CDACallback<CDASyncedSpace> callback, Response response, CDASpace space) {
        this.originalSpace = originalSpace;
        this.updatedSpace = updatedSpace;
        this.callback = callback;
        this.response = response;
        this.space = space;
    }

    @Override
    public CDASyncedSpace call() throws Exception {
        if (this.originalSpace != null) {
            ArrayList<CDAResource> originalItems = new ArrayList<CDAResource>(this.originalSpace.getItems());
            ArrayList<CDAResource> updatedItems = this.updatedSpace.getItems();
            for (int i = updatedItems.size() - 1; i >= 0; --i) {
                CDAResource item = updatedItems.get(i);
                Constants.CDAResourceType resourceType = Constants.CDAResourceType.valueOf((String)item.getSys().get("type"));
                if (Constants.CDAResourceType.DeletedAsset.equals((Object)resourceType)) {
                    item.getSys().put("type", Constants.CDAResourceType.Asset.toString());
                    originalItems.remove(item);
                    continue;
                }
                if (Constants.CDAResourceType.DeletedEntry.equals((Object)resourceType)) {
                    item.getSys().put("type", Constants.CDAResourceType.Entry.toString());
                    originalItems.remove(item);
                    continue;
                }
                if (!Constants.CDAResourceType.Asset.equals((Object)resourceType) && !Constants.CDAResourceType.Entry.equals((Object)resourceType)) continue;
                originalItems.remove(item);
                originalItems.add(0, item);
            }
            updatedItems.clear();
            updatedItems.addAll(originalItems);
        }
        CDASyncedSpace result = null;
        try {
            result = (CDASyncedSpace)new ArrayParser<CDASyncedSpace>(this.updatedSpace, this.space).call();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.callback != null && !this.callback.isCancelled()) {
            this.callback.success(result, this.response);
        }
        return result;
    }
}

