/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.api;

import com.contentful.java.lib.Constants;
import com.contentful.java.model.ArrayResource;
import com.contentful.java.model.CDAArray;
import com.contentful.java.model.CDAAsset;
import com.contentful.java.model.CDAEntry;
import com.contentful.java.model.CDAResource;
import com.contentful.java.model.CDASpace;
import com.contentful.java.model.CDASyncedSpace;
import com.contentful.java.model.Locale;
import com.contentful.java.model.ResourceWithMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

class ArrayParser<T extends ArrayResource>
implements Callable<T> {
    private final T source;
    private final CDASpace space;

    public ArrayParser(T source, CDASpace space) {
        this.source = source;
        this.space = space;
    }

    @Override
    public T call() throws Exception {
        ArrayList<CDAResource> items;
        HashMap<String, CDAResource> assets = new HashMap<String, CDAResource>();
        HashMap<String, CDAResource> entries = new HashMap<String, CDAResource>();
        boolean sync = this.source instanceof CDASyncedSpace;
        if (sync) {
            items = ((CDASyncedSpace)this.source).getItems();
        } else if (this.source instanceof CDAArray) {
            items = ((CDAArray)this.source).getItems();
            CDAArray.Includes includes = ((CDAArray)this.source).getIncludes();
            if (includes != null) {
                List<CDAAsset> list = includes.getAssets();
                List<CDAEntry> includedEntries = includes.getEntries();
                if (list != null) {
                    for (CDAResource cDAResource : list) {
                        assets.put((String)cDAResource.getSys().get("id"), cDAResource);
                    }
                }
                if (includedEntries != null) {
                    for (CDAResource cDAResource : includedEntries) {
                        entries.put((String)cDAResource.getSys().get("id"), cDAResource);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid result item.");
        }
        for (CDAResource cDAResource : items) {
            if (sync && cDAResource instanceof ResourceWithMap) {
                this.setLocalizedFields((ResourceWithMap)cDAResource);
            }
            if (cDAResource instanceof CDAAsset) {
                assets.put((String)cDAResource.getSys().get("id"), cDAResource);
                continue;
            }
            if (!(cDAResource instanceof CDAEntry)) continue;
            entries.put((String)cDAResource.getSys().get("id"), cDAResource);
        }
        for (Map.Entry entry : entries.entrySet()) {
            CDAResource item = (CDAResource)entry.getValue();
            if (!(item instanceof ResourceWithMap)) continue;
            this.resolveResourceLinks(item, assets, entries);
        }
        return this.source;
    }

    private void setLocalizedFields(ResourceWithMap res) {
        Map<String, Object> rawFields = res.getRawFields();
        HashMap<String, Map> localizedFieldsMap = res.getLocalizedFieldsMap();
        for (Locale locale : this.space.getLocales()) {
            HashMap map = new HashMap();
            for (String key : rawFields.keySet()) {
                String code = locale.code;
                Map item = (Map)rawFields.get(key);
                Object value = item.get(code);
                if (value != null) {
                    map.put(key, value);
                }
                localizedFieldsMap.put(code, map);
            }
        }
    }

    private void resolveResourceLinks(CDAResource resource, HashMap<String, CDAResource> assets, HashMap<String, CDAResource> entries) {
        ResourceWithMap res = (ResourceWithMap)resource;
        HashMap<String, Map> localizedFields = res.getLocalizedFieldsMap();
        for (Map fields : localizedFields.values()) {
            for (Object k : fields.keySet()) {
                Object value = fields.get(k);
                if (value instanceof Map) {
                    CDAResource match = this.getMatchForField((Map)value, assets, entries);
                    if (match == null) continue;
                    fields.put(k, match);
                    continue;
                }
                if (!(value instanceof List)) continue;
                List list = (List)value;
                for (int i = 0; i < list.size(); ++i) {
                    CDAResource match;
                    Object item = list.get(i);
                    if (!(item instanceof Map) || (match = this.getMatchForField((Map)item, assets, entries)) == null) continue;
                    list.set(i, match);
                }
            }
        }
    }

    private CDAResource getMatchForField(Map map, HashMap<String, CDAResource> assets, HashMap<String, CDAResource> entries) {
        String type;
        CDAResource result = null;
        Map sys = (Map)map.get("sys");
        if (sys != null && Constants.CDAResourceType.Link.equals((Object)Constants.CDAResourceType.valueOf(type = (String)sys.get("type")))) {
            Constants.CDAResourceType linkType = Constants.CDAResourceType.valueOf((String)sys.get("linkType"));
            String id = (String)sys.get("id");
            if (Constants.CDAResourceType.Asset.equals((Object)linkType)) {
                result = assets.get(id);
            } else if (Constants.CDAResourceType.Entry.equals((Object)linkType)) {
                result = entries.get(id);
            } else if (Constants.CDAResourceType.Space.equals((Object)linkType)) {
                result = this.space;
            }
        }
        return result;
    }
}

