/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.api;

import com.contentful.java.api.ArrayParser;
import com.contentful.java.api.CDAClient;
import com.contentful.java.api.Utils;
import com.contentful.java.model.ArrayResource;
import com.contentful.java.model.CDAArray;
import com.contentful.java.model.CDASyncedSpace;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;

class ArrayResourceTypeAdapter
implements JsonDeserializer<ArrayResource> {
    private final CDAClient client;
    private final Gson gson;

    ArrayResourceTypeAdapter(CDAClient client, Gson gson) {
        this.client = client;
        this.gson = gson;
    }

    public ArrayResource deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        CDASyncedSpace syncedSpace;
        String nextSyncUrl;
        ArrayResource result = (ArrayResource)this.gson.fromJson(jsonElement, type);
        if (CDAArray.class.equals((Object)type)) {
            try {
                result = this.parseArray((CDAArray)result);
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }
        if (CDASyncedSpace.class.equals((Object)type) && (nextSyncUrl = (syncedSpace = (CDASyncedSpace)result).getNextSyncUrl()) != null) {
            try {
                syncedSpace.setSyncToken(Utils.getQueryParamFromUrl(nextSyncUrl, "sync_token"));
            }
            catch (UnsupportedEncodingException e) {
                throw new JsonParseException("Unable to retrieve sync token.");
            }
        }
        return result;
    }

    <T extends ArrayResource> T parseArray(T source) throws Exception {
        return (T)new ArrayParser<T>(source, this.client.getSpace()).call();
    }
}

