/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.api;

import com.contentful.java.api.CDACallback;
import retrofit.RetrofitError;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.schedulers.Schedulers;

final class RxExtensions {
    private RxExtensions() {
        throw new UnsupportedOperationException();
    }

    static <R> CDACallback<R> defer(DefFunc<R> func, CDACallback<R> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback may not be null.");
        }
        Observable.defer(func).observeOn(Schedulers.io()).subscribe(new ActionSuccess<R>(callback), (Action1)new ActionError((CDACallback)callback));
        return callback;
    }

    static abstract class DefFunc<T>
    implements Func0<Observable<T>> {
        DefFunc() {
        }

        public final Observable<T> call() {
            return Observable.just(this.method());
        }

        abstract T method();
    }

    static class ActionError
    extends AbsAction<Throwable> {
        public ActionError(CDACallback callback) {
            super(callback);
        }

        public void call(Throwable t) {
            if (!this.callback.isCancelled()) {
                if (t instanceof RetrofitError) {
                    this.callback.onFailure((RetrofitError)t);
                } else {
                    this.callback.onFailure(RetrofitError.unexpectedError(null, (Throwable)t));
                }
            }
        }
    }

    static class ActionSuccess<T>
    extends AbsAction<T> {
        public ActionSuccess(CDACallback<T> callback) {
            super(callback);
        }

        public void call(T t) {
            if (!this.callback.isCancelled()) {
                this.callback.onSuccess(t, null);
            }
        }
    }

    static abstract class AbsAction<T>
    implements Action1<T> {
        final CDACallback<T> callback;

        public AbsAction(CDACallback<T> callback) {
            this.callback = callback;
        }
    }
}

