/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.api;

import com.contentful.java.api.CDACallback;
import com.contentful.java.api.CDAClient;
import com.contentful.java.api.SpaceMerger;
import com.contentful.java.model.CDASyncedSpace;
import retrofit.RetrofitError;
import retrofit.client.Response;

class SyncSpaceCallback
extends CDACallback<CDASyncedSpace> {
    private final CDASyncedSpace originalSpace;
    private final CDAClient client;
    private final CDACallback<CDASyncedSpace> wrappedCallback;

    public SyncSpaceCallback(CDASyncedSpace originalSpace, CDAClient client, CDACallback<CDASyncedSpace> wrappedCallback) {
        this.originalSpace = originalSpace;
        this.client = client;
        this.wrappedCallback = wrappedCallback;
    }

    @Override
    protected void onSuccess(CDASyncedSpace updatedSpace, Response response) {
        if (!this.wrappedCallback.isCancelled()) {
            this.client.executorService.submit(new SpaceMerger(this.originalSpace, updatedSpace, this.wrappedCallback, response, this.client.getSpace()));
        }
    }

    @Override
    protected void onFailure(RetrofitError retrofitError) {
        super.onFailure(retrofitError);
        if (!this.wrappedCallback.isCancelled()) {
            this.wrappedCallback.onFailure(retrofitError);
        }
    }
}

