/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import android.os.Handler;
import android.os.Looper;
import com.contentful.java.cda.SynchronousExecutor;
import java.lang.reflect.Field;
import java.util.concurrent.Executor;

public abstract class Platform {
    static Platform platform = null;

    public static Platform get() {
        if (platform == null) {
            platform = Platform.findPlatform();
        }
        return platform;
    }

    public abstract Executor callbackExecutor();

    public abstract String name();

    public abstract String version();

    public abstract boolean needsCustomTLSSocketFactory();

    private static Platform findPlatform() {
        int androidVersionNumber = Platform.tryGettingAndroidSDKNumber();
        if (androidVersionNumber > 0) {
            return new Android(androidVersionNumber, Platform.tryGettingAndroidReleaseVersionString());
        }
        return new Base();
    }

    private static String tryGettingAndroidReleaseVersionString() {
        try {
            Class<?> buildsVersionClass = Class.forName("android.os.Build$VERSION");
            Field releaseField = buildsVersionClass.getField("RELEASE");
            return (String)releaseField.get(null);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static int tryGettingAndroidSDKNumber() {
        try {
            Class<?> buildsVersionClass = Class.forName("android.os.Build$VERSION");
            Field versionInt = buildsVersionClass.getField("SDK_INT");
            return (Integer)versionInt.get(null);
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    static class Android
    extends Platform {
        private static final int ANDROID_VERSION_FIRST_TO_ENABLE_TLS_12 = 20;
        private final int versionNumber;
        private final String versionName;

        Android(int versionNumber, String versionName) {
            this.versionNumber = versionNumber;
            this.versionName = versionName;
        }

        @Override
        public Executor callbackExecutor() {
            return new Executor(){
                private final Handler handler = new Handler(Looper.getMainLooper());

                @Override
                public void execute(Runnable command) {
                    this.handler.post(command);
                }
            };
        }

        @Override
        public String name() {
            return "Android";
        }

        @Override
        public String version() {
            return this.versionName;
        }

        @Override
        public boolean needsCustomTLSSocketFactory() {
            return this.versionNumber < 20;
        }
    }

    static class Base
    extends Platform {
        Base() {
        }

        @Override
        public Executor callbackExecutor() {
            return new SynchronousExecutor();
        }

        @Override
        public String name() {
            return System.getProperty("os.name", "");
        }

        @Override
        public String version() {
            return System.getProperty("os.version", "");
        }

        @Override
        public boolean needsCustomTLSSocketFactory() {
            return false;
        }
    }
}

