/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDAAsset;
import com.contentful.java.cda.CDAContentType;
import com.contentful.java.cda.CDAEntry;
import com.contentful.java.cda.CDALocale;
import com.contentful.java.cda.CDAResource;
import com.contentful.java.cda.CDASpace;
import com.contentful.java.cda.CDAType;
import com.contentful.java.cda.DeletedResource;
import java.util.Map;
import okhttp3.HttpUrl;

final class Util {
    private Util() {
        throw new AssertionError();
    }

    static <T> T checkNotNull(T reference, String format, Object ... args) {
        if (reference == null) {
            throw new NullPointerException(String.format(format, args));
        }
        return reference;
    }

    static CharSequence checkNotEmpty(CharSequence string, String format, Object ... args) {
        if (string == null) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return string;
    }

    static String resourcePath(Class<? extends CDAResource> clazz) {
        if (CDAAsset.class.equals(clazz)) {
            return "assets";
        }
        if (CDAContentType.class.equals(clazz)) {
            return "content_types";
        }
        if (CDAEntry.class.equals(clazz)) {
            return "entries";
        }
        if (CDALocale.class.equals(clazz)) {
            return "locales";
        }
        throw new IllegalArgumentException("Invalid type specified: " + clazz.getName());
    }

    static Class<? extends CDAResource> classForType(CDAType type) {
        if (CDAType.ASSET.equals((Object)type)) {
            return CDAAsset.class;
        }
        if (CDAType.CONTENTTYPE.equals((Object)type)) {
            return CDAContentType.class;
        }
        if (CDAType.ENTRY.equals((Object)type)) {
            return CDAEntry.class;
        }
        if (CDAType.SPACE.equals((Object)type)) {
            return CDASpace.class;
        }
        if (CDAType.LOCALE.equals((Object)type)) {
            return CDALocale.class;
        }
        if (CDAType.DELETEDASSET.equals((Object)type) || CDAType.DELETEDENTRY.equals((Object)type)) {
            return DeletedResource.class;
        }
        throw new IllegalArgumentException("Invalid type provided: " + (Object)((Object)type));
    }

    static CDAType typeForClass(Class<? extends CDAResource> clazz) {
        if (CDAAsset.class.equals(clazz)) {
            return CDAType.ASSET;
        }
        if (CDAContentType.class.equals(clazz)) {
            return CDAType.CONTENTTYPE;
        }
        if (CDAEntry.class.equals(clazz)) {
            return CDAType.ENTRY;
        }
        if (CDASpace.class.equals(clazz)) {
            return CDAType.SPACE;
        }
        if (CDALocale.class.equals(clazz)) {
            return CDAType.LOCALE;
        }
        throw new IllegalArgumentException("Invalid class provided: " + clazz.getName());
    }

    static <T> T extractNested(Map<?, ?> source, Object ... keys) {
        Map curr = source;
        for (int i = 0; i < keys.length; ++i) {
            if (i == keys.length - 1) {
                return (T)curr.get(keys[i]);
            }
            if ((curr = (Map)curr.get(keys[i])) == null) break;
        }
        return null;
    }

    static String queryParam(String url, String name) {
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            return null;
        }
        return httpUrl.queryParameter(name);
    }
}

