/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDACallback;
import com.contentful.java.cda.CDAClient;
import io.reactivex.Flowable;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

final class Callbacks {
    private Callbacks() {
        throw new AssertionError();
    }

    static <O, C> CDACallback<C> subscribeAsync(Flowable<O> flowable, CDACallback<C> callback, CDAClient client) {
        ConnectableFlowable connectable = flowable.observeOn(Schedulers.io()).publish();
        callback.setSubscription(connectable.subscribe(new SuccessAction(callback, client), (Consumer)new FailureAction(callback, client)));
        connectable.connect();
        return callback;
    }

    static class FailureRunnable
    implements Runnable {
        private final Throwable throwable;
        private final CDACallback<?> callback;

        FailureRunnable(Throwable throwable, CDACallback<?> callback) {
            this.throwable = throwable;
            this.callback = callback;
        }

        @Override
        public void run() {
            if (!this.callback.isCancelled()) {
                this.callback.onFailure(this.throwable);
            }
        }
    }

    static class SuccessRunnable<E>
    implements Runnable {
        private final E result;
        private final CDACallback<E> callback;

        SuccessRunnable(E result, CDACallback<E> callback) {
            this.result = result;
            this.callback = callback;
        }

        @Override
        public void run() {
            if (!this.callback.isCancelled()) {
                this.callback.onSuccess(this.result);
            }
        }
    }

    static class FailureAction
    extends BaseAction<Throwable> {
        FailureAction(CDACallback<?> callback, CDAClient client) {
            super(callback, client);
        }

        @Override
        protected void doCall(Throwable t) {
            this.execute(new FailureRunnable(t, this.callback));
        }
    }

    static class SuccessAction<E>
    extends BaseAction<E> {
        SuccessAction(CDACallback<?> callback, CDAClient client) {
            super(callback, client);
        }

        @Override
        protected void doCall(E e) {
            this.execute(new SuccessRunnable<E>(e, this.callback));
        }
    }

    static abstract class BaseAction<E>
    implements Consumer<E> {
        protected final CDACallback<?> callback;
        protected final CDAClient client;

        BaseAction(CDACallback<?> callback, CDAClient client) {
            this.callback = callback;
            this.client = client;
        }

        public void accept(E e) {
            if (!this.callback.isCancelled()) {
                this.doCall(e);
            }
            this.callback.unsubscribe();
        }

        protected abstract void doCall(E var1);

        protected void execute(Runnable r) {
            this.client.callbackExecutor.execute(r);
        }
    }
}

