/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda.rich;

import com.contentful.java.cda.ArrayResource;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.CDAEntry;
import com.contentful.java.cda.CDAField;
import com.contentful.java.cda.ResourceUtils;
import com.contentful.java.cda.rich.CDARichBlock;
import com.contentful.java.cda.rich.CDARichDocument;
import com.contentful.java.cda.rich.CDARichEmbeddedBlock;
import com.contentful.java.cda.rich.CDARichEmbeddedInline;
import com.contentful.java.cda.rich.CDARichHeading;
import com.contentful.java.cda.rich.CDARichHorizontalRule;
import com.contentful.java.cda.rich.CDARichHyperLink;
import com.contentful.java.cda.rich.CDARichListItem;
import com.contentful.java.cda.rich.CDARichMark;
import com.contentful.java.cda.rich.CDARichNode;
import com.contentful.java.cda.rich.CDARichOrderedList;
import com.contentful.java.cda.rich.CDARichParagraph;
import com.contentful.java.cda.rich.CDARichQuote;
import com.contentful.java.cda.rich.CDARichText;
import com.contentful.java.cda.rich.CDARichUnorderedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RichTextFactory {
    private static final int HEADING_LEVEL_1 = 1;
    private static final int HEADING_LEVEL_2 = 2;
    private static final int HEADING_LEVEL_3 = 3;
    private static final int HEADING_LEVEL_4 = 4;
    private static final int HEADING_LEVEL_5 = 5;
    private static final int HEADING_LEVEL_6 = 6;
    private static final Map<String, Resolver> RESOLVER_MAP = new HashMap<String, Resolver>();

    public static void resolveRichTextField(ArrayResource array, CDAClient client) {
        for (CDAEntry entry : array.entries().values()) {
            ResourceUtils.ensureContentType(entry, client);
            for (CDAField field : entry.contentType().fields()) {
                if (!"RichText".equals(field.type())) continue;
                RichTextFactory.resolveRichDocument(entry, field);
                RichTextFactory.resolveRichLink(array, entry, field);
            }
        }
    }

    private static void resolveRichDocument(CDAEntry entry, CDAField field) {
        Map rawValue = (Map)entry.rawFields().get(field.id());
        if (rawValue == null) {
            return;
        }
        for (String locale : rawValue.keySet()) {
            Map raw = (Map)rawValue.get(locale);
            if (raw == null) continue;
            entry.setField(locale, field.id(), RESOLVER_MAP.get("document").resolve(raw));
        }
    }

    static List<CDARichMark> resolveMarks(List<Map<String, Object>> rawMarks) {
        ArrayList<CDARichMark> marks = new ArrayList<CDARichMark>(rawMarks.size());
        for (Map<String, Object> rawMark : rawMarks) {
            String type = (String)rawMark.get("type");
            if ("bold".equals(type)) {
                marks.add(new CDARichMark.CDARichMarkBold());
                continue;
            }
            if ("italic".equals(type)) {
                marks.add(new CDARichMark.CDARichMarkItalic());
                continue;
            }
            if ("underline".equals(type)) {
                marks.add(new CDARichMark.CDARichMarkUnderline());
                continue;
            }
            if ("code".equals(type)) {
                marks.add(new CDARichMark.CDARichMarkCode());
                continue;
            }
            marks.add(new CDARichMark.CDARichMarkCustom(type));
        }
        return marks;
    }

    static CDARichNode resolveRichNode(Map<String, Object> rawNode) {
        String type = (String)rawNode.get("nodeType");
        if (RESOLVER_MAP.containsKey(type)) {
            return RESOLVER_MAP.get(type).resolve(rawNode);
        }
        return null;
    }

    private static void resolveRichLink(ArrayResource array, CDAEntry entry, CDAField field) {
        Map rawValue = (Map)entry.rawFields().get(field.id());
        if (rawValue == null) {
            return;
        }
        for (String locale : rawValue.keySet()) {
            CDARichDocument document = (CDARichDocument)entry.getField(locale, field.id());
            for (CDARichNode node : document.getContent()) {
                RichTextFactory.resolveOneLink(array, field, locale, node);
            }
        }
    }

    private static void resolveOneLink(ArrayResource array, CDAField field, String locale, CDARichNode node) {
        block6: {
            block2: {
                Object target;
                Map data;
                block3: {
                    block4: {
                        String id;
                        String linkType;
                        block5: {
                            if (!(node instanceof CDARichHyperLink)) break block2;
                            CDARichHyperLink link = (CDARichHyperLink)node;
                            data = (Map)link.data;
                            target = data.get("target");
                            if (!(target instanceof Map)) break block3;
                            if (!RichTextFactory.isLink(target)) break block4;
                            Map map = (Map)target;
                            Map sys = (Map)map.get("sys");
                            linkType = (String)sys.get("linkType");
                            id = (String)sys.get("id");
                            if (!"Asset".equals(linkType)) break block5;
                            link.data = array.assets().get(id);
                            break block6;
                        }
                        if (!"Entry".equals(linkType)) break block6;
                        link.data = array.entries().get(id);
                        break block6;
                    }
                    throw new IllegalStateException("Could not parse content of data field '" + field.id() + "' for locale '" + locale + "' at node '" + node + "'. Please check your content type model.");
                }
                if (target != null || !data.containsKey("uri")) break block6;
                link.data = data.get("uri");
                break block6;
            }
            if (node instanceof CDARichParagraph) {
                for (CDARichNode child : ((CDARichParagraph)node).getContent()) {
                    RichTextFactory.resolveOneLink(array, field, locale, child);
                }
            }
        }
    }

    private static boolean isLink(Object data) {
        try {
            Map map = (Map)data;
            Map sys = (Map)map.get("sys");
            String type = (String)sys.get("type");
            String linkType = (String)sys.get("linkType");
            String id = (String)sys.get("id");
            if ("Link".equals(type) && ("Entry".equals(linkType) || "Asset".equals(linkType) && id != null)) {
                return true;
            }
        }
        catch (ClassCastException cast) {
            return false;
        }
        return false;
    }

    static {
        RESOLVER_MAP.put("text", new Resolver(){

            @Override
            public CDARichNode resolve(Map<String, Object> raw) {
                return new CDARichText((CharSequence)raw.get("value"), RichTextFactory.resolveMarks((List)raw.get("marks")));
            }
        });
        RESOLVER_MAP.put("hr", new Resolver(){

            @Override
            public CDARichNode resolve(Map<String, Object> raw) {
                return new CDARichHorizontalRule();
            }
        });
        RESOLVER_MAP.put("blockquote", new BlockResolver<CDARichQuote>(new Supplier<CDARichQuote>(){

            @Override
            public CDARichQuote get() {
                return new CDARichQuote();
            }
        }));
        RESOLVER_MAP.put("paragraph", new BlockResolver<CDARichParagraph>(new Supplier<CDARichParagraph>(){

            @Override
            public CDARichParagraph get() {
                return new CDARichParagraph();
            }
        }));
        RESOLVER_MAP.put("document", new BlockResolver<CDARichDocument>(new Supplier<CDARichDocument>(){

            @Override
            public CDARichDocument get() {
                return new CDARichDocument();
            }
        }));
        RESOLVER_MAP.put("list-item", new BlockResolver<CDARichListItem>(new Supplier<CDARichListItem>(){

            @Override
            public CDARichListItem get() {
                return new CDARichListItem();
            }
        }));
        RESOLVER_MAP.put("ordered-list", new BlockResolver<CDARichOrderedList>(new Supplier<CDARichOrderedList>(){

            @Override
            public CDARichOrderedList get() {
                return new CDARichOrderedList();
            }
        }));
        RESOLVER_MAP.put("unordered-list", new BlockResolver<CDARichUnorderedList>(new Supplier<CDARichUnorderedList>(){

            @Override
            public CDARichUnorderedList get() {
                return new CDARichUnorderedList();
            }
        }));
        RESOLVER_MAP.put("hyperlink", new BlockAndDataResolver<CDARichHyperLink>(new SupplierWithData<CDARichHyperLink>(){

            @Override
            public CDARichHyperLink get(Object target) {
                return new CDARichHyperLink(target);
            }
        }, "data"));
        RESOLVER_MAP.put("entry-hyperlink", new BlockAndDataResolver<CDARichHyperLink>(new SupplierWithData<CDARichHyperLink>(){

            @Override
            public CDARichHyperLink get(Object target) {
                return new CDARichHyperLink(target);
            }
        }, "data"));
        RESOLVER_MAP.put("asset-hyperlink", new BlockAndDataResolver<CDARichHyperLink>(new SupplierWithData<CDARichHyperLink>(){

            @Override
            public CDARichHyperLink get(Object target) {
                return new CDARichHyperLink(target);
            }
        }, "data"));
        RESOLVER_MAP.put("embedded-entry-block", new BlockAndDataResolver<CDARichEmbeddedBlock>(new SupplierWithData<CDARichEmbeddedBlock>(){

            @Override
            public CDARichEmbeddedBlock get(Object target) {
                return new CDARichEmbeddedBlock(target);
            }
        }, "data"));
        RESOLVER_MAP.put("embedded-entry-inline", new BlockAndDataResolver<CDARichEmbeddedInline>(new SupplierWithData<CDARichEmbeddedInline>(){

            @Override
            public CDARichEmbeddedInline get(Object target) {
                return new CDARichEmbeddedInline(target);
            }
        }, "data"));
        RESOLVER_MAP.put("embedded-asset-block", new BlockAndDataResolver<CDARichEmbeddedBlock>(CDARichEmbeddedBlock::new, "data"));
        RESOLVER_MAP.put("heading-1", new HeadingResolver(1));
        RESOLVER_MAP.put("heading-2", new HeadingResolver(2));
        RESOLVER_MAP.put("heading-3", new HeadingResolver(3));
        RESOLVER_MAP.put("heading-4", new HeadingResolver(4));
        RESOLVER_MAP.put("heading-5", new HeadingResolver(5));
        RESOLVER_MAP.put("heading-6", new HeadingResolver(6));
    }

    private static class BlockAndDataResolver<T extends CDARichBlock>
    extends BlockResolver<T> {
        final SupplierWithData<T> supplier;
        final String dataFieldKey;

        BlockAndDataResolver(SupplierWithData<T> supplier, String dataFieldKey) {
            super(null);
            this.supplier = supplier;
            this.dataFieldKey = dataFieldKey;
        }

        @Override
        T getCDAType(Map<String, Object> raw) {
            return (T)((CDARichBlock)this.supplier.get(raw.get(this.dataFieldKey)));
        }
    }

    private static interface SupplierWithData<T> {
        public T get(Object var1);
    }

    private static class HeadingResolver
    extends BlockResolver<CDARichHeading> {
        final int level;

        HeadingResolver(final int level) {
            super(new Supplier<CDARichHeading>(){

                @Override
                public CDARichHeading get() {
                    return new CDARichHeading(level);
                }
            });
            this.level = level;
        }
    }

    private static class BlockResolver<T extends CDARichBlock>
    implements Resolver {
        final Supplier<T> supplier;

        BlockResolver(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public CDARichNode resolve(Map<String, Object> raw) {
            T resolved = this.getCDAType(raw);
            List contents = (List)raw.get("content");
            for (Map rawNode : contents) {
                CDARichNode resolvedNode = RichTextFactory.resolveRichNode(rawNode);
                if (resolvedNode == null) continue;
                ((CDARichBlock)resolved).content.add(resolvedNode);
            }
            return resolved;
        }

        T getCDAType(Map<String, Object> raw) {
            return (T)((CDARichBlock)this.supplier.get());
        }
    }

    private static interface Supplier<T> {
        public T get();
    }

    private static interface Resolver {
        public CDARichNode resolve(Map<String, Object> var1);
    }
}

